
#include-once

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GuiEdit.au3>

Const $str80 = "--------------------------------------------------------------------------------"

;--- Main Window handle
;
$hMsgLogWnd    = 0

;--- Control IDs
;
$IDMsgLogEdit  = 0
$IDMsgLogClose = 0
$IDMsgLogOnTop = 0

;--- Control handles
;
$hMsgLogEdit   = 0
$hMsgLogClose  = 0
$hMsgLogOnTop  = 0

;--- Create a Message Log Window
;
MessageLog_Create()

;--- Set the Messaage Log 'Text Limit'.
;
; This is the maximum amount of text (in TCHARs) that the control can contain.
; For ANSI text, this is the number of bytes;
; For Unicode text, this is the number of characters.
;
; Two documents with the same character limit will yield the same text limit,
; even if one is ANSI and the other is Unicode.
;
MessageLog_SetTextLimit( 1000000 )

;-------------------------------------------------------------------------------
Func MessageLog_Show()
;-------------------------------------------------------------------------------

;--- Give focus to the message log window.
;
WinActivate( $hMsgLogWnd )
GUICtrlSetState( $IDMsgLogClose, $GUI_ENABLE )
GUICtrlSetState( $IDMsgLogOnTop, $GUI_ENABLE )

;--- Run the GUI until the dialog is closed.
;
While 1
    Switch GUIGetMsg()

    Case $GUI_EVENT_CLOSE, $IDMsgLogClose
    Return

    Case $IDMsgLogOnTop
    If ControlCommand( $hMsgLogWnd, "", $IDMsgLogOnTop, "IsChecked", "" ) Then
        WinActivate( $hMsgLogWnd )
        WinSetOnTop( $hMsgLogWnd, "", 1 )
    Else
        WinSetOnTop( $hMsgLogWnd, "", 0 )
    EndIf

    EndSwitch
WEnd

EndFunc

;-------------------------------------------------------------------------------
Func MessageLog( $sText, $bAddCRLF = True, $Indent = 0, $EndAt = 0 )
;-------------------------------------------------------------------------------
If $hMsgLogWnd  AND  $IDMsgLogEdit Then

    If $Indent > 0 Then
        For $i = 1 To $Indent
            _GUICtrlEdit_AppendText( $IDMsgLogEdit, " " )
        Next
    EndIf

    _GUICtrlEdit_AppendText( $IDMsgLogEdit, $sText )

    If $EndAt > 0 Then
        $n = $EndAt - ( $Indent + StringLen($sText) )
        For $i = 1 To $n
            _GUICtrlEdit_AppendText( $IDMsgLogEdit, " " )
        Next
    EndIf

    If $bAddCRLF Then _GUICtrlEdit_AppendText( $IDMsgLogEdit, @CRLF )

EndIf
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_Create()
;-------------------------------------------------------------------------------

;---------------------------------------
; Create... GUI window
;---------------------------------------
$Style1 = $GUI_SS_DEFAULT_GUI
$Style2 = BitAND( $GUI_SS_DEFAULT_GUI, BitNOT($WS_SYSMENU) )
$Style3 = $WS_OVERLAPPEDWINDOW
$Style4 = BitAND( $WS_OVERLAPPEDWINDOW, BitNOT($WS_MINIMIZEBOX) )
$Style5 = $WS_POPUP

$GUI_Title        = @ScriptName
$GUI_ClientWidth  = @DesktopWidth  / 8 * 5
$GUI_ClientHeight = @DesktopHeight / 8 * 5
$GUI_Style        = $Style3

$hMsgLogWnd = GUICreate( $GUI_Title, $GUI_ClientWidth, $GUI_ClientHeight, -1, -1, $GUI_Style )

;---------------------------------------
; Create... Checkbox control
;---------------------------------------
$Top    = 2
$Height = 24
$Left   = 24
$Width  = 100

$IDMsgLogOnTop = GUICtrlCreateCheckbox( "Always On Top", $Left, $Top, -1, -1, $WS_DISABLED )

GUICtrlSetResizing( $IDMsgLogOnTop, $GUI_DOCKTOP + $GUI_DOCKLEFT + $GUI_DOCKSIZE )

;---------------------------------------
; Create... Button control
;---------------------------------------
$Top    = 2
$Height = 24
$Left   = $GUI_ClientWidth - 24 - $Width
$Width  = 100

$IDMsgLogClose = GUICtrlCreateButton( "Close", $Left, $Top, $Width, $Height, $WS_DISABLED )

GUICtrlSetResizing( $IDMsgLogClose, $GUI_DOCKTOP + $GUI_DOCKRIGHT + $GUI_DOCKSIZE )

;---------------------------------------
; Create... Edit control
;---------------------------------------
$Top    = 2 + 24 + 1
$Height = $GUI_ClientHeight - $Top
$Left   = 0
$Width  = $GUI_ClientWidth
$Style  = BitOR( $WS_CHILD, $WS_VISIBLE, $ES_MULTILINE, $ES_READONLY, $WS_VSCROLL, $WS_HSCROLL )

$IDMsgLogEdit = GUICtrlCreateEdit( "", $Left, $Top, $Width, $Height, $Style )

GUICtrlSetResizing( $IDMsgLogEdit, $GUI_DOCKTOP + $GUI_DOCKBOTTOM )

$FontName = "Lucida Console"
$FontSize = 10
GUICtrlSetFont( $IDMsgLogEdit, $FontSize, 400, 0, $FontName )

;---------------------------------------
; Display the GUI window.
;---------------------------------------
GUISetState( @SW_SHOW )
GUISetState( @SW_SHOWMAXIMIZED )

;---------------------------------------
; Register Message Handlers
;---------------------------------------
GUIRegisterMsg( $WM_GETMINMAXINFO, "On_WM_GETMINMAXINFO" )

;---------------------------------------
; Get Handles
;---------------------------------------
$hMsgLogEdit  = ControlGetHandle( $hMsgLogWnd, "", $IDMsgLogEdit  )
$hMsgLogClose = ControlGetHandle( $hMsgLogWnd, "", $IDMsgLogClose )
$hMsgLogOnTop = ControlGetHandle( $hMsgLogWnd, "", $IDMsgLogOnTop )

EndFunc

;-------------------------------------------------------------------------------
Func On_WM_GETMINMAXINFO( $hWnd, $iMsg, $wParam, $lParam )
;-------------------------------------------------------------------------------
; Set min/max GUI sizes.

$iGUIMinX = 300
$iGUIMinY = 200
$iGUIMaxX = @DesktopWidth
$iGUIMaxY = @DesktopHeight

$tMinMaxInfo = DllStructCreate("int;int;int;int;int;int;int;int;int;int", $lParam)
DllStructSetData($tMinMaxInfo,  7, $iGUIMinX)
DllStructSetData($tMinMaxInfo,  8, $iGUIMinY)
DllStructSetData($tMinMaxInfo,  9, $iGUIMaxX)
DllStructSetData($tMinMaxInfo, 10, $iGUIMaxY)

Return 0
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_GetContents()
;-------------------------------------------------------------------------------
; Returns the entire contents of the Edit control.

Return GUICtrlRead( $IDMsgLogEdit )
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_DeleteContents()
;-------------------------------------------------------------------------------
; Delete the entire contents of the Edit control.

_GUICtrlEdit_SetSel( $IDMsgLogEdit, 0, -1 )
_GUICtrlEdit_ReplaceSel( $IDMsgLogEdit, "", False )
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_ReplaceContents( $str = "" )
;-------------------------------------------------------------------------------
; Replace the entire contents of the Edit control with variable '$str'.

_GUICtrlEdit_SetSel( $IDMsgLogEdit, 0, -1 )
_GUICtrlEdit_SetText( $IDMsgLogEdit, $str )
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_Destroy()
;-------------------------------------------------------------------------------

;--- Delete the 'Message Log Window' and all controls that it contains.
;
GUIDelete( $hMsgLogWnd )

;--- Main Window handle
;
$hMsgLogWnd    = 0

;--- Control IDs
;
$IDMsgLogEdit  = 0
$IDMsgLogClose = 0
$IDMsgLogOnTop = 0

;--- Control handles
;
$hMsgLogEdit   = 0
$hMsgLogClose  = 0
$hMsgLogOnTop  = 0

EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_WriteToFile( $FileName )
;-------------------------------------------------------------------------------
; Write the entire contents of the Edit control to a file.

If FileExists( $FileName ) Then FileDelete( $FileName )

;--- FileOpen( $FileName, $FileOpenMode )
;
;    $FileOpenMode:
;        2 = Write mode (erase previous contents).
;        8 = Create directory structure if it doesn't exist.
;
$hFile = FileOpen( $FileName, 2+8 )

If $hFile <> -1 Then
    $str = GUICtrlRead( $IDMsgLogEdit )
    FileWrite( $hFile, $str )
    FileClose( $hFile )
EndIf

EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_AppendToFile( $FileName )
;-------------------------------------------------------------------------------
; Write the entire contents of the Edit control to a file.

;--- FileOpen( $FileName, $FileOpenMode )
;
;    $FileOpenMode:
;        1 = Write mode (append to end of file)
;        8 = Create directory structure if it doesn't exist.
;
$hFile = FileOpen( $FileName, 1+8 )

If $hFile <> -1 Then
    $str = GUICtrlRead( $IDMsgLogEdit )
    FileWrite( $hFile, $str )
    FileClose( $hFile )
EndIf

EndFunc

;-------------------------------------------------------------------------------
; Func MessageLog_SetTextLimit( $iTextLimit )
; Func MessageLog_GetTextLimit()
;-------------------------------------------------------------------------------
;
; This is the 'text limit' for the message log edit control.
; This is the maximum amount of text (in TCHARs) that the control can contain.
; For ANSI text, this is the number of bytes;
; For Unicode text, this is the number of characters.
;
; Two documents with the same character limit will yield the same text limit,
; even if one is ANSI and the other is Unicode.
;
;-------------------------------------------------------------------------------
Func MessageLog_SetTextLimit( $iTextLimit )
;-------------------------------------------------------------------------------
_GUICtrlEdit_SetLimitText( $hMsgLogEdit, $iTextLimit )
Return _GUICtrlEdit_GetLimitText( $hMsgLogEdit )
EndFunc

;-------------------------------------------------------------------------------
Func MessageLog_GetTextLimit()
;-------------------------------------------------------------------------------
Return _GUICtrlEdit_GetLimitText( $hMsgLogEdit )
EndFunc

