
#include-once

#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <ColorConstants.au3>
#include <FontConstants.au3>

;-------------------------------------------------------------------------------
Func MsgBoxEx( $Title, $Text )
;-------------------------------------------------------------------------------
If True Then
    $FontName      = "Verdana"
    $FontSize      = 9
    $FontWeight    = $FW_BOLD
    $FontAttribute = 0
Else
    $FontName      = "Lucida Console"
    $FontSize      = 10
    $FontWeight    = $FW_BOLD
    $FontAttribute = 0
Endif

;---------------------------------------
; GUI
;---------------------------------------
$ClientWidth  = 500
$ClientHeight = 500
$Style        = $WS_CAPTION + $WS_CLIPCHILDREN + $WS_CLIPSIBLINGS + $WS_SYSMENU
$StyleEx      = $WS_EX_TOPMOST
$hGUI         = GUICreate( $Title, $ClientWidth, $ClientHeight, -1, -1, $Style, $StyleEx )

GUISetFont( $FontSize, $FontWeight, $FontAttribute, $FontName, $hGUI )

;---------------------------------------
; Static control
;---------------------------------------
$ID_TEXT    = GUICtrlCreateLabel( $Text, 0, 0, -1, -1 )
$hTEXT      = ControlGetHandle ( $hGUI, "", $ID_TEXT )
$array      = WinGetClientSize( $hTEXT )
$TextWidth  = $array[0]
$TextHeight = $array[1]

;---------------------------------------
; Create new GUI with proper Client Width/Height
;---------------------------------------
GUIDelete( $hGUI )

$TextBORDER_X = 32
$TextBORDER_Y = 32
$ButtonPane   = 42
$ButtonWidth  = 75

$ClientWidth  = $TextWidth  + $TextBORDER_X
$ClientHeight = $TextHeight + $TextBORDER_Y + $ButtonPane

$MinX = $ButtonWidth + 42
If $ClientWidth < $MinX Then $ClientWidth = $MinX

$hGUI = GUICreate( $Title, $ClientWidth, $ClientHeight, -1, -1, $Style, $StyleEx )

GUISetBkColor( 0xA8CDFF, $hGUI )

;---------------------------------------
; Static control
;---------------------------------------
$ID_STATIC = GUICtrlCreateLabel( "", 0, 0, $ClientWidth, $TextHeight + $TextBORDER_Y )
GUICtrlSetBkColor( $ID_STATIC,  0xC3DDFF )

;---------------------------------------
; Static control
;---------------------------------------
$ID_TEXT = GUICtrlCreateLabel( $Text, 0, 0, -1, -1 )
GUICtrlSetFont( $ID_TEXT, $FontSize, $FontWeight, $FontAttribute, $FontName )
GUICtrlSetBkColor( $ID_TEXT,  0xC3DDFF )
GUICtrlSetPos( $ID_TEXT, 0, 0, $TextWidth, $TextHeight )

;---------------------------------------
; Center $ID_TEXT in $ID_STATIC
;---------------------------------------
$a = ControlGetPos( $hGUI, "", $ID_STATIC )

$x = ($ClientWidth - $TextWidth) / 2
$y = ($a[3] - $TextHeight) / 2

GUICtrlSetPos( $ID_TEXT, $x, $y )

;---------------------------------------
; Button [OK]
;---------------------------------------
$Top    = $ClientHeight - 24 - 4
$Height = 24
$Left   = $ClientWidth - $ButtonWidth - 8
$Width  = $ButtonWidth

$ID_OK = GUICtrlCreateButton( "OK", $Left, $Top, $Width, $Height )

;---------------------------------------
; Run the GUI
;---------------------------------------
GUISetState( @SW_SHOW, $hGUI )

$OldOption = AutoItSetOption( "GUIOnEventMode", 0 )
While 1
    Switch GUIGetMsg()
        Case $GUI_EVENT_CLOSE, $ID_OK
        GUIDelete( $hGUI )
        AutoItSetOption( "GUIOnEventMode", $OldOption )
        ExitLoop
    EndSwitch
WEnd
Return
EndFunc

