
#pragma compile(x64, false)

Opt("ExpandEnvStrings", 1)

If @WorkingDir <> @ScriptDir Then FileChangeDir( @ScriptDir )

#include "Include\MessageLog.au3"
#include "Include\MsgBoxEx.au3"

;-------------------------------------------------------------------------------
; Global Constants
;-------------------------------------------------------------------------------
Const $LogFile = @ScriptFullPath & "__Log.txt"
Const $INIFile = @ScriptFullPath & "__Log.ini"

;-------------------------------------------------------------------------------
; DEBUG
;-------------------------------------------------------------------------------
$msg  = "AutoLogon_CurrentUser()" & @CRLF & @CRLF
$msg &= "Open the Windows Registry Editor" & @CRLF
$msg &= "Examine these keys..." & @CRLF
$msg &= "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" & @CRLF
$msg &= "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows NT\CurrentVersion\Winlogon" & @CRLF

Initialize()
Winlogon_Save()
AutoLogon_CurrentUser()
MsgBoxEx("DEBUG", $msg)
Winlogon_Restore()
MsgBoxEx("DEBUG", $msg)
Exit 0

;-------------------------------------------------------------------------------
Func Initialize()
;-------------------------------------------------------------------------------
MessageLog("Operating System : " & @OSVersion & "_" & @OSArch & " " & @OSServicePack )
MessageLog("Account Name     : " & @UserName)
MessageLog("")

If FileExists( $LogFile ) Then FileDelete( $LogFile )
If FileExists( $INIFile ) Then FileDelete( $INIFile )

EndFunc

;-------------------------------------------------------------------------------
Func Winlogon_Save()
;-------------------------------------------------------------------------------
; Save the original registry values.

$Key = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"

IniWrite( $INIFile, "Winlogon", "Key",  $Key )

Dim $ValName[3]
$ValName[0] = "AutoAdminLogon"
$ValName[1] = "DefaultUserName"
$ValName[2] = "DefaultPassword"

For $i = 0 To UBound( $ValName )-1

    $Data = RegRead( $Key, $ValName[$i] )
    If @error Then $Data = "VALUE NAME DOES NOT EXIST"
    IniWrite( $INIFile, "Winlogon", $ValName[$i],  $Data )
Next
EndFunc

;-------------------------------------------------------------------------------
Func Winlogon_Restore()
;-------------------------------------------------------------------------------
; Restore the original registry values.

$Key = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"

Dim $ValName[3]
$ValName[0] = "AutoAdminLogon"
$ValName[1] = "DefaultUserName"
$ValName[2] = "DefaultPassword"

For $i = 0 To UBound( $ValName )-1

    $Data = IniRead( $INIFile, "Winlogon", $ValName[$i], "NoKey" )
    If $Data <> "NoKey" Then

        If $Data = "VALUE NAME DOES NOT EXIST" Then
            RegDelete( $Key, $ValName[$i] )
        Else
            RegWrite( $Key, $ValName[$i],  "REG_SZ", $Data )
        EndIf
    EndIf
Next
EndFunc

;-------------------------------------------------------------------------------
Func AutoLogon_CurrentUser()
;-------------------------------------------------------------------------------
If @UserName = "Administrator" Then
    UserAccount_AutoLogOn( "Administrator", "password" )
Else
    UserAccount_AutoLogOn()
EndIf
EndFunc

;-------------------------------------------------------------------------------
Func UserAccount_AutoLogOn( $AccountName=@UserName, $Password=0 )
;-------------------------------------------------------------------------------
$Key = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"

RegWrite( $Key, "AutoAdminLogon",  "REG_SZ", "1"          )
RegWrite( $Key, "DefaultUserName", "REG_SZ", $AccountName )

If $Password Then
    RegWrite( $Key, "DefaultPassword", "REG_SZ", $Password )
Else
    RegDelete( $Key, "DefaultPassword" )
EndIf
EndFunc

