#include <MsgBoxConstants.au3>
#include <WinAPIFiles.au3>
#include <APIFilesConstants.au3>

Example_WinAPI_GetDriveType()

Func Example_WinAPI_GetDriveType()

    Local $iTypeOfDrive = _WinAPI_GetDriveType("C:")
    If $iTypeOfDrive = $DRIVE_UNKNOWN Or $iTypeOfDrive = $DRIVE_NO_ROOT_DIR Then
        MsgBox($MB_SYSTEMMODAL, "Failure", "The path is invalid or the type cannot be determined")
    EndIf

    Switch $iTypeOfDrive
        ; Case $DRIVE_UNKNOWN
        ;    ConsoleWrite("The drive type cannot be determined." & @LF)
        ; Case $DRIVE_NO_ROOT_DIR
        ;    ConsoleWrite("The root path is invalid; for example, there is no volume mounted at the specified path." & @LF)
        Case $DRIVE_REMOVABLE
            ConsoleWrite("The drive has removable media; for example, a floppy drive, thumb drive, or flash card reader." & @LF)
        Case $DRIVE_FIXED
            ConsoleWrite("The drive has fixed media; for example, a hard disk drive or flash drive." & @LF)
        Case $DRIVE_REMOTE
            ConsoleWrite("The drive is a remote (network) drive." & @LF)
        Case $DRIVE_CDROM
            ConsoleWrite("The drive is a CD-ROM drive." & @LF)
        Case $DRIVE_RAMDISK
            ConsoleWrite("The drive is a RAM disk." & @LF)
    EndSwitch

    Return $iTypeOfDrive
EndFunc   ;==>Example_WinAPI_GetDriveType