#include <MsgBoxConstants.au3>
#include <WinAPIProc.au3>
#include <APIProcConstants.au3>


Example()

Func Example()

	; run notepad
	Run("notepad.exe")
	Local $iPID = ProcessWait("notepad.exe")

	; get Priority Description
	Local $sPriorityDesc = Example_WinAPI_GetPriorityClass($iPID)

	; show the message
	If Not @error Then
		MsgBox($MB_SYSTEMMODAL, Hex(@extended), $sPriorityDesc)
	Else
		MsgBox(0, "Failure", "_WinAPI_GetPriorityClass")
	EndIf

	; CleanUp
	ProcessClose($iPID)

EndFunc   ;==>Example

Func Example_WinAPI_GetPriorityClass($iPID)

	; Check Priorrity
	Local $Class = _WinAPI_GetPriorityClass($iPID)
	If Not $Class Then
		Return SetError(1)
	EndIf

	; setting return value
	Switch $Class
		Case $ABOVE_NORMAL_PRIORITY_CLASS
			Return SetError(0, $ABOVE_NORMAL_PRIORITY_CLASS, "ABOVE_NORMAL_PRIORITY_CLASS")
		Case $BELOW_NORMAL_PRIORITY_CLASS
			Return SetError(0, $BELOW_NORMAL_PRIORITY_CLASS, "BELOW_NORMAL_PRIORITY_CLASS")
		Case $HIGH_PRIORITY_CLASS
			Return SetError(0, $HIGH_PRIORITY_CLASS, "HIGH_PRIORITY_CLASS")
		Case $IDLE_PRIORITY_CLASS
			Return SetError(0, $IDLE_PRIORITY_CLASS, "IDLE_PRIORITY_CLASS")
		Case $NORMAL_PRIORITY_CLASS
			Return SetError(0, $NORMAL_PRIORITY_CLASS, "NORMAL_PRIORITY_CLASS")
		Case $REALTIME_PRIORITY_CLASS
			Return SetError(0, $REALTIME_PRIORITY_CLASS, "REALTIME_PRIORITY_CLASS")
	EndSwitch
EndFunc   ;==>Example_WinAPI_GetPriorityClass
