#include <GUIConstantsEx.au3>
#include <GuiRichEdit.au3>
#include <WindowsConstants.au3>
#include <MsgBoxConstants.au3>

Example()

Func Example()
	Local $iMsg
	Local $hGui = GUICreate("Example (" & StringTrimRight(@ScriptName, 4) & ")", 320, 250, -1, -1)
	Local $hRichEdit1 = _GUICtrlRichEdit_Create($hGui, "This is a first test.", 10, 10, 300, 220, BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL))
	_GUICtrlRichEdit_AppendText($hRichEdit1, @CRLF & "This is more text" & @CRLF)

	GUISetState(@SW_SHOW)

	_GUICtrlRichEdit_SelectionTest($hRichEdit1)

	While True
		$iMsg = GUIGetMsg()
		Select
			Case $iMsg = $GUI_EVENT_CLOSE
				_GUICtrlRichEdit_Destroy($hRichEdit1) ; needed unless script crashes
				; GUIDelete() 	; is OK too
				Exit
		EndSelect
	WEnd
EndFunc   ;==>Example

Func _GUICtrlRichEdit_SelectionTest(ByRef $hSourceRichEdit)
	Local $bIsSelected = _GUICtrlRichEdit_IsTextSelected($hSourceRichEdit)
	Local $kError = @error
	MsgBox($MB_SYSTEMMODAL, 'before Selection', 'Try to select manualy, and after selection, press OK button')
	Local $vRichEdit_Stream = _GUICtrlRichEdit_StreamToVar($hSourceRichEdit)
	MsgBox($MB_SYSTEMMODAL, 'Selection Test','$bIsSelected = ' & $bIsSelected & ' @error = ' & $kError& @CRLF & @CRLF & $vRichEdit_Stream)
EndFunc   ;==>_GUICtrlRichEdit_SelectionTest
