#include <GUIConstantsEx.au3>
#include <GuiEdit.au3>
#include <MsgBoxConstants.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>

Example()

Func Example()

	; create example GUI
	Local $hGUI = GUICreate('Example', 300, 150, -1, 100)

	; create Edit
	Local $idText = GUICtrlCreateEdit('', 5, 10, 280, 80)
	; set CueBanner text to the Edit control
	_GUICtrlEdit_SetCueBanner($idText, 'Type the text here...... ')

	; create Input
	Local $idPassword = GUICtrlCreateInput('', 5, 95, 280, 25)
	; set CueBanner text to the Input control
	_GUICtrlEdit_SetCueBanner($idPassword, 'Enter password here.')

	; create some other button
	Local $idClose = GUICtrlCreateButton('&Close', 210, 120, 85, 25)
	ControlFocus($hGUI, '', $idClose)

	; show the GUI
	GUISetState(@SW_SHOW, $hGUI)

	; check CueBanner text for $idPassword
	MsgBox($MB_SYSTEMMODAL, '_GUICtrlEdit_GetCueBanner()', 'Return Value = ' & _GUICtrlEdit_GetCueBanner($idPassword))

	; Loop until the user exits.
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $idClose
				ExitLoop

		EndSwitch
	WEnd

	; CleanUp
	GUIDelete($hGUI)
EndFunc   ;==>Example
