#include-once

Global $adStateOpen = 1

;===============================================================================
;
; Function Name:    _SQLConnect
; Description:      Initiate a connection to a SQL database
; Syntax:           $oConn = _SQLConnect($sServer, $sDatabase, $fAuthMode = 0, $sUsername = "", $sPassword = "", _
;                       $sDriver = "{SQL Server}")
; Parameter(s):     $sServer - The server your database is on
;                   $sDatabase - Database to connect to
;                   $fAuthMode - Authorization mode (0 = Windows Logon, 1 = SQL) (default = 0)
;                   $sUsername - The username to connect to the database with (default = "")
;                   $sPassword - The password to connect to the database with (default = "")
;                   $sDriver (optional) the ODBC driver to use (default = "{SQL Server}")
;                   $bEncrypt - Whether to use encryption (default = False)
; Requirement(s):   Autoit 3 with COM support
; Return Value(s):  On success - returns the connection object for subsequent SQL calls
;                   On failure - returns 0 and sets @error:
;                       @error=1 - Error opening database connection
;                       @error=2 - ODBC driver not installed
;                       @error=3 - ODBC connection failed
; Author(s):        SEO and unknown
; Note(s):          See http://msdn.microsoft.com/en-us/library/ms130822%28v=sql.100%29.aspx for the connection string parameters.
;
;===============================================================================
Func _SQLConnect(Const $sServer, Const $sDatabase, Const $fAuthMode = 0, Const $sUsername = "", Const $sPassword = "", Const $sDriver = "SQL Server", Const $bEncrypt = False)
     Local $sKey = "HKEY_LOCAL_MACHINE\SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers", $sVal = RegRead($sKey, $sDriver)
     If @error Or $sVal = "" Then Return SetError(2, 0, 0)
     Local $oConn = ObjCreate("ADODB.Connection")
     If Not IsObj($oConn) Then Return SetError(3, 0, 0)
     Local $sEncrypt = $bEncrypt ? "YES" : "NO"
     If $fAuthMode Then $oConn.Open ("DRIVER={" & $sDriver & "};SERVER={" & $sServer & "};ENCRYPT={" & $sEncrypt & "};DATABASE={" & $sDatabase & "};UID={" & $sUsername & "};PWD={" & $sPassword & "}")
     If Not $fAuthMode Then $oConn.Open("DRIVER={" & $sDriver & "};SERVER={" & $sServer & "};ENCRYPT={" & $sEncrypt & "};DATABASE={" & $sDatabase & "}")
     If @error Then Return SetError(1, 0, 0)
     Return $oConn
EndFunc   ;==>_SQLConnect

;===============================================================================
;
; Function Name:    _SQLConnect
; Description:      Send a query to a SQL database and return the results as an object
; Syntax:           $oQuery = _SQLQuery($oConn, $sQuery)
; Parameter(s):     $oConn - A database connection object created by a previous call to _SQLConnect
;                   $sQuery - The SQL query string to be executed by the SQL server
; Requirement(s):   Autoit 3 with COM support
; Return Value(s):  On success - returns the query result as an object
;                   On failure - returns 0 and sets @error:
;                       @error=1 - Unable to process the query
; Author(s):        SEO and unknown
; Note(s):          None
;
;===============================================================================
Func _SQLQuery(Const $oConn, Const $sQuery)
     If IsObj($oConn) Then Return $oConn.Execute($sQuery)
     Return SetError(1, 0, 0)
EndFunc   ;==>_SQLQuery

;===============================================================================
;
; Function Name:    _SQLDisconnect
; Description:      Disconnect and close an existing connection to a SQL database
; Syntax:           _SQLDisconnect($oConn)
; Parameter(s):     $oConn - A database connection object created by a previous call to _SQLConnect
; Requirement(s):   Autoit 3 with COM support
; Return Value(s):  On success - returns 1 and closes the ODBC connection
;                   On failure - returns 0 and sets @error:
;                       @error=1 - Database connection object doesn't exist
; Author(s):        SEO and unknown
; Note(s):          None
;
;===============================================================================
Func _SQLDisconnect(ByRef $oConn)
     If Not IsObj($oConn) Then Return SetError(1, 0, 0)
     $oConn.Close
	 $oConn = Null
     Return 1
EndFunc   ;==>_SQLDisconnect