#pragma compile(Console, true)

Local Const $VERSION_STRING = "1.0.0.0"
Global Const $SRC_FILE = "comtest.au3"

#include "mssql.au3"

Opt("MustDeclareVars", 1)

Local $PROGRAM_STRING = "comtest"
Local $argc  = $CmdLine[0]
Local $argv0 = @ScriptName
Local $iniFileName = @ScriptDir & "\settings.ini"

Func _WriteDiag(Const $errType, Const $errDesc)
    ConsoleWriteError($PROGRAM_STRING&": "&$errType&": "&$errDesc&@CRLF)
EndFunc

Func _WriteOut(Const $textType, Const $textDesc)
    ConsoleWrite($PROGRAM_STRING&": "&$textType&": "&$textDesc)
EndFunc

; Read the INI file for the value of 'Server' in the section labelled 'Connection'.
Global $sServer = False
$sServer = IniRead($iniFileName, "Connection", "Server", $sServer)
If IsBool($sServer) And Not $sServer Then
    ConsoleWriteError($PROGRAM_STRING&": "&$iniFileName&": the Server parameter must be specified"&@CRLF)
    Exit(1)
EndIf

; Read the INI file for the value of 'Database' in the section labelled 'Connection'.
Global $sDatabase = False
$sDatabase = IniRead($iniFileName, "Connection", "Database", $sDatabase)
If IsBool($sDatabase) And Not $sDatabase Then
    ConsoleWriteError($PROGRAM_STRING&": "&$iniFileName&": the Database parameter must be specified"&@CRLF)
    Exit(1)
EndIf

; Read the INI file for the value of 'AuthMode' in the section labelled 'Connection'.
Local $fAuthMode = "Windows Logon"
$fAuthMode = IniRead($iniFileName, "Connection", "AuthMode", $fAuthMode)
Switch $fAuthMode
    Case "Windows Logon"
        $fAuthMode = 0
    Case "SQL"
        $fAuthMode = 1
    Case Else
        ConsoleWriteError($PROGRAM_STRING&": "&$iniFileName&": the AuthMode parameter must be either ""Windows Logon"" or ""SQL"""&@CRLF)
        Exit(1)
EndSwitch

; Read the INI file for the value of 'Username' in the section labelled 'Connection'.
Local $sUsername = ""
$sUsername = IniRead($iniFileName, "Connection", "Username", $sUsername)

; Read the INI file for the value of 'Password' in the section labelled 'Connection'.
Local $sPassword = ""
$sPassword = IniRead($iniFileName, "Connection", "Password", $sPassword)

; Read the INI file for the value of 'Driver' in the section labelled 'Connection'.
Global $sDriver = "SQL Server"
$sDriver = IniRead($iniFileName, "Connection", "Driver", $sDriver)

; Read the INI file for the value of 'Encrypt' in the section labelled 'Connection'.
Local $bEncrypt = "NO"
$bEncrypt = IniRead($iniFileName, "Connection", "Encrypt", $bEncrypt)
Switch $bEncrypt
    Case "NO"
        $bEncrypt = False
    Case "YES"
        $bEncrypt = True
    Case Else
        _WriteDiag("Settings Error", $iniFileName&":"&@CRLF&"The Encrypt parameter must be either ""YES"" or ""NO"".")
        Exit(1)
EndSwitch

Global $oConn = Null, $oRecordSet = Null, $oFields = Null
OnAutoItExitRegister("_CleanUp")

Global $COMstatusMessage = ""
; First install our own Error Handler
Global $g_nCOMError = 0, $g_oErrObj = Null

$g_oErrObj = ObjEvent("AutoIt.Error", "_COMerrorHandler")

$COMstatusMessage = "attempting connection"
$oConn = _SQLConnect($sServer, $sDatabase, $fAuthMode, $sUsername, $sPassword, $sDriver, $bEncrypt)
Local $error = @error

If Not IsObj($oConn) Then
    Switch $error
        Case 1
            _WriteDiag("Database Error", "Could not connect to SQL Server at "&$SRC_FILE&" line "&@ScriptLineNumber&"."&@CRLF&"Verify the connection parameters in "&$iniFileName&" and try again.")
        Case 2
            _WriteDiag("Database Error", "The ODBC Driver is not installed on this computer.")
        Case 3
            _WriteDiag("Database Error", "Could not connect to ODBC driver"&@CRLF&"Verify that the ODBC Driver is correctly installed on this computer.")
        Case Else
            _WriteDiag("Database Error", "Unknown error code "&$error)
    EndSwitch
    Exit(1)
EndIf

$COMstatusMessage = "attempting to close record set"
If IsObj($oRecordSet) Then
    If $oRecordSet.State() = $adStateOpen Then $oRecordSet.Close()
EndIf

Local $oRecordSet = _DoSearch()
Exit(0)

Func _ExecStatements(Const $oConn, Const $sStatements, Const $bIgnoreInvalidObjRef = False)
    _WriteDiag("Info", "Executing: "&@CRLF&$sStatements)
    $COMstatusMessage = "attempting to execute query"

    If $bIgnoreInvalidObjRef Then
        $g_oErrObj = ObjEvent("AutoIt.Error", "_COMwarningHandlerWrapper")
    EndIf

    Local $oRecordSet = _SQLQuery($oConn, $sStatements)

    If $bIgnoreInvalidObjRef Then
        $g_oErrObj = ObjEvent("AutoIt.Error", "_COMerrorHandler")
    EndIf

    Return $oRecordSet
EndFunc

Func _DoSearch()
    Local $dropStatement = "DROP TABLE [#Temp]"&@CRLF

	Local $oTmpRecordSet = Null

	$oTmpRecordSet = _ExecStatements($oConn, $dropStatement, True)
	$COMstatusMessage = "attempting to close record set"
	If IsObj($oTmpRecordSet) Then
		If $oTmpRecordSet.State() = $adStateOpen Then $oTmpRecordSet.Close()
		$oTmpRecordSet = Null
	EndIf

	$oRecordSet = _ExecStatements($oConn, $dropStatement, False) ; CRASH!
	Return $oRecordSet
EndFunc

Func _CleanUp()
    $g_oErrObj = ObjEvent("AutoIt.Error", "_COMwarningHandler")

    $COMstatusMessage = "attempting to close record set"
    If IsObj($oRecordSet) Then
        If $oRecordSet.State() = $adStateOpen Then $oRecordSet.Close()
        $oRecordSet = Null
    EndIf

    $COMstatusMessage = "attempting to disconnect"
    If IsObj($oConn) Then
        If $oConn.State() = $adStateOpen Then $oConn.Close()
        $oConn = Null
    EndIf
EndFunc   ;==>CleanUp

Func _WriteCOMerror()
    _WriteDiag("COM Error while "&$COMstatusMessage, _
        @CRLF&"Description: " & $g_oErrObj.description & @CRLF & _
        "Window Description: " & $g_oErrObj.windescription & @CRLF & _
        "Last DLL Error: " & $g_oErrObj.lastdllerror & @CRLF & _
        "Script Line: " & $g_oErrObj.scriptline & @CRLF & _
        "Error Number: 0x" & Hex($g_oErrObj.number, 8) & @CRLF & _
        "Error Source: " & $g_oErrObj.source & @CRLF & _
        "Help File: " & $g_oErrObj.helpfile & @CRLF & _
        "Help Context: " & $g_oErrObj.helpcontext & @CRLF & _
        "Return Code: 0x" & Hex($g_oErrObj.retcode, 8) _
    )

    $g_nCOMError = $g_oErrObj.number
EndFunc   ;==>_WriteCOMerror

Func _COMerrorHandler()
    _WriteCOMerror()
    Exit(1)
EndFunc

Func _COMwarningHandler()
    _WriteCOMerror()
EndFunc

Func _COMerrorIsInvalidObjRef()
    Return $g_oErrObj.number = 0x80020009 And $g_oErrObj.retcode = 0x80040E37
EndFunc

Func _COMerrorHandlerWrapper()
    If Not _COMerrorIsInvalidObjRef() Then
        _WriteCOMerror()
        Exit(1)
    EndIf
EndFunc

Func _COMwarningHandlerWrapper()
    If Not _COMerrorIsInvalidObjRef() Then
        _WriteCOMerror()
    EndIf
EndFunc