#include <Constants.au3>

;; SETTINGS HERE, CHANGE THESE
Global Const $sAdminPass = "manadar" ;; Admin password. Change this please.
;; END OF SETTINGS, STOP CHANGING!!

;; TCP Variables
Dim $sMaxConnections = 10
Dim $hSocket[$sMaxConnections], $sBuffer[$sMaxConnections], $iAuth[$sMaxConnections], $hCommand[$sMaxConnections], $bIgnoreCommand[$sMaxConnections]

;; TCP Options
Dim $sIPAddress = @IPAddress1, $nPort = 5000

TCPStartup()

$sMainSocket = TCPListen($sIPAddress, $nPort, 5)
If @error Then
    Switch @error
        Case 1
            _FatalError("The listening address was incorrect (Possibly another server was already running): " & $sIPAddress)
        Case 2
            _FatalError("The listening port was incorrect (Possibly another server was already running): " & $nPort)
        Case Else
            _FatalError("Unable to set up a listening server on " & $sIPAddress & ":" & $nPort)
    EndSwitch
EndIf

While 1
    ;; Accept new incoming clients, and ask them to authorise.
    $sNewSocket = TCPAccept($sMainSocket)
    If $sNewSocket > -1 Then
        For $x = 0 To UBound($hSocket) - 1
            If Not $hSocket[$x] Then
                $hSocket[$x] = $sNewSocket
                $iAuth[$x] = 0
                ;TCPSend($hSocket[$x], $sWelcomeMessage & @CRLF & @CRLF)
                TCPSend($hSocket[$x], "Please enter the administrator password" & @CRLF & ">")
                ExitLoop
            EndIf
        Next
    EndIf

    ;; Loop through existing connections, check if they sent us any data
    For $x = 0 To UBound($hSocket) - 1
        If $hSocket[$x] Then

            ;; Handle incoming data
            $sData = TCPRecv($hSocket[$x], 100)
            $sBuffer[$x] &= $sData
            If @error Then
				MsgBox(0,"test",@error)
                TCPCloseSocket($hSocket[$x])
                $hSocket[$x] = ""
                $sBuffer[$x] = ""
                $iAuth[$x] = 0
                ProcessClose($hCommand[$x])
            ElseIf Asc($sData) = 0x8 Then ;backspace received
                $len = StringLen($sBuffer[$x])
                $sBuffer[$x] = StringTrimRight($sBuffer[$x], 2) ; trim the buffer
                If $len = 1 Then
                    TCPSend($hSocket[$x], ">")
                Else
                    TCPSend($hSocket[$x], " " & Chr(0x8))
                EndIf
            EndIf

            ;; Handle data, in case data is complete: ended with newline
            If StringInStr($sBuffer[$x], @CRLF) Then
                $sBuffer[$x] = StringTrimRight($sBuffer[$x], 2)
                If StringLen($sBuffer[$x]) = 0 Then
                    $sBuffer[$x] = " " ; You cannot send "nothing" over TCP (no packet is sent), thus I replace it with something non obstrusive
                EndIf

                ;; Check if user is authorised
                If $iAuth[$x] == 0 Then
                    ;; Not authorised, user is typing password
                    If ($sBuffer[$x] == $sAdminPass) Then
                        $iAuth[$x] = 1
                        $hCommand[$x] = Run("cmd", @ScriptDir, @SW_HIDE, $STDIN_CHILD + $STDERR_CHILD + $STDOUT_CHILD)
                        TCPSend($hSocket[$x], "Administrator authorisation granted." & @CRLF & @CRLF)
                        ConsoleWrite($x & " logged in with admin password." & @CRLF)
                    Else
                        TCPSend($hSocket[$x], "Access denied." & @CRLF & ">")
                    EndIf
                Else
                    If $sBuffer[$x] <> "" Then ; stop making output if user starts typing, then punch him in the face or something for fucking it up
                        ConsoleWrite($sBuffer[$x] & @CRLF)
                        StdinWrite($hCommand[$x], $sBuffer[$x] & @CRLF)
                        $bIgnoreCommand[$x] = True
                    EndIf
                EndIf
                $sBuffer[$x] = ""
            EndIf

            If $iAuth[$x] Then ; no @CRLF in buffer, but user is authed for output
                $line = StdoutRead($hCommand[$x])
                If $line <> "" Then
                    If $bIgnoreCommand[$x] Then
                        $line = StringTrimLeft($line, StringInStr($line, @LF)+1)
                        $bIgnoreCommand[$x] = False
                    EndIf
                    ConsoleWrite($line & @CRLF)
                    TCPSend($hSocket[$x], $line)
                EndIf
            EndIf
        EndIf
    Next
WEnd

Func MessageBroadcast($sMsg)
    For $n = 0 To UBound($hSocket) - 1
        If $hSocket[$n] AND $iAuth[$n] == 1 Then
            TCPSend($hSocket[$n], $sMsg)
        EndIf
    Next
EndFunc   ;==>MessageBroadcast

Func _FatalError($msg)
    ConsoleWrite(@CRLF & "! " & $msg & @CRLF)
    ;MsgBox(0, $sAppName & $nVersion, "A fatal error has occured and " & $sAppName & " has to be closed with the error message: " & @CRLF & $msg)
    Exit
EndFunc
