#include <Excel.au3>
#include <Array.au3>

; AutoIT 3.3.12.0 (Production), tested with Excel 2007.
; 
; _Excel_RangeFind test file 
;
; Testing search functionality by searching for strings in and across sheets.

; Create Excel object 
Local $oExcel = _Excel_Open()

; Create two new sheets, both with one sheet each.
Local $oBookNumbers = _Excel_BookNew($oExcel, 1)
Local $oBookLetters = _Excel_BookNew($oExcel, 1)

; Populate sheets with data. 
For $i = 1 To 100
	$oBookNumbers.Sheets(1).Range("A" & String($i)).Value = $i
	$oBookLetters.Sheets(1).Range("A" & String($i)).Value = _Excel_ColumnToLetter($i)
Next

; Define search results variable
Local $search

MsgBox(0, "Active sheet", "The following four searches search the active sheet. These work as expected.")

; Set the active sheet to the sheet with numbers...
$oBookNumbers.Sheets(1).Activate

; These searches will work just fine. 
$search = _Excel_RangeFind($oBookNumbers, "42", "A1:A100")
_ArrayDisplay($search, """42"" on active sheet (numbers) with range as string")
$search = _Excel_RangeFind($oBookNumbers, "42", $oBookNumbers.Sheets(1).Range("A1:A100"))
_ArrayDisplay($search, """42"" on active sheet (numbers) with range as object")

; Set the active sheet to the one with letters...
$oBookLetters.Sheets(1).Activate

; Once again, both of these searches should also work fine. 
$search = _Excel_RangeFind($oBookLetters, "AF", "A1:A100")
_ArrayDisplay($search, """AF"" on active sheet (letters) with range as string")
$search = _Excel_RangeFind($oBookLetters, "AF", $oBookLetters.Sheets(1).Range("A1:A100"))
_ArrayDisplay($search, """AF"" on active sheet (letters) with range as object")

MsgBox(0, "Cross-sheet", "The following four searches search the inactive book. The first and third fail, but do not return errors.")

; Set the active sheet to the one with letters...
$oBookLetters.Sheets(1).Activate

; Despite each book only having one sheet, the string search fails if the search sheet is not active.
$search = _Excel_RangeFind($oBookNumbers, "42", "A1:A100")
_ArrayDisplay($search, """42"" on numbers sheet with range as string. Failed search")
$search = _Excel_RangeFind($oBookNumbers, "42", $oBookNumbers.Sheets(1).Range("A1:A100"))
_ArrayDisplay($search, """42"" on numbers sheet with range as object")

; Set the active sheet to the one with numbers...
$oBookNumbers.Sheets(1).Activate

; Same thing with searching numbers.
$search = _Excel_RangeFind($oBookLetters, "AF", "A1:A100")
_ArrayDisplay($search, """AF"" on letters sheet with range as string. Failed search")
$search = _Excel_RangeFind($oBookLetters, "AF", $oBookLetters.Sheets(1).Range("A1:A100"))
_ArrayDisplay($search, """AF"" on letters sheet with range as object")