#include <Debug.au3>

_DebugSetup("Debug Out", False, 1)
_DebugOut("Debug start")

;-----------------------------------------------------------------------
; Setup Outlook environment
;-----------------------------------------------------------------------
$olApp       = ObjCreate("Outlook.Application")
$olNameSpace = $olApp.GetNameSpace("MAPI")
Dim $archive = $olNameSpace.PickFolder

;-----------------------------------------------------------------------
; Save number of mails to Drafts folder
;-----------------------------------------------------------------------
$timestamp = @HOUR & ":" & @MIN & ":" & @SEC
Dim $Mail
for $i = 1 to 10
   _DebugOut("Adding mail #" & $i)
   $Mail = $olApp.CreateItem(0)
   $Mail.Subject = "Test mail (" & $timestamp & ") [" & $i & "]"
   $Mail.HTMLBody = "<HTML><p>test</p></HTML>"
   $Mail.save()
   Sleep(1000)
Next

;-----------------------------------------------------------------------
; Delete all items using a FOR..IN..NEXT loop
;-----------------------------------------------------------------------
$oParentFld = $Mail.Parent
$iteration = 0
For $j in $oParentFld.Items
   $iteration += 1
   _DebugOut("Deleting mail, loop " & $iteration)
   $j.Delete
   Sleep(1000)
Next

_DebugOut("Loop has finished, " & $oParentFld.Items.Count & " items remaining in folder.")