#include <Debug.au3>

_DebugSetup("Debug Out", False, 1)
_DebugOut("Debug start")

Global $oMyError = ObjEvent("AutoIt.Error","MyErrFunc")

;-----------------------------------------------------------------------
; Setup Excel environment
;-----------------------------------------------------------------------
$oExcel = ObjCreate("Excel.Application")
$oExcel.Visible = True
$oExcel.SheetsInNewWorkbook = 1

;-----------------------------------------------------------------------
; Create workbook and fill with sheets
;-----------------------------------------------------------------------
$oWB = $oExcel.workbooks.add
for $i = 1 to 5
   $oWB.Sheets.Add
   _DebugOut("Now " & $oWB.Worksheets.Count & " sheets in workbook")
   Sleep(1000)
Next

;-----------------------------------------------------------------------
; Delete all sheets using FOR .. IN .. NEXT loop
; Will crash deleting last sheets but that is not the issue here and I decided to leave it in
;-----------------------------------------------------------------------
For $sheet In $oWB.Worksheets
   $sheet.Delete
   _DebugOut("Now " & $oWB.Worksheets.Count & " sheets in workbook")
   Sleep(1000)
Next

Exit

;-----------------------------------------------------------------------
; Error Handler
;-----------------------------------------------------------------------
Func MyErrFunc($oMyError)
Local $HexNumber
Local $strMsg

$HexNumber = Hex($oMyError.Number, 8)
$strMsg = "Error Number: " & $HexNumber & @CRLF
$strMsg &= "WinDescription: " & $oMyError.WinDescription & @CRLF
$strMsg &= "Script Line: " & $oMyError.ScriptLine & @CRLF
MsgBox(0, "ERROR", $strMsg)
SetError(1)

Endfunc