#include <Excel.au3>
#include <Array.au3>

func _openSourceData()
$sourcefile=FileOpenDialog("Please select source file",@ScriptDir,"All (*.*)")
    If @error Then
        ; Display the error message.
        MsgBox($MB_SYSTEMMODAL, "", "No file(s) were selected.")
    else
    ; Create application object
    Local $oAppl = _Excel_Open()
    If @error Then Exit MsgBox(16, "Excel UDF: _Excel_BookOpen Example", "Error creating the Excel application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
    ; *****************************************************************************
    ; Open an existing workbook and return its object identifier.
    ; *****************************************************************************
    Local $sWorkbook = $sourcefile
    $oWorkbook = _Excel_BookOpen($oAppl, $sWorkbook, Default, Default, True)
    If @error Then Exit MsgBox($MB_SYSTEMMODAL, "Excel UDF: _Excel_BookOpen Example 1", "Error opening '" & $sWorkbook & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
        $sourceArray=_Excel_RangeRead($oWorkbook)
        _ArrayDisplay($sourceArray)
        $unique=_ArrayUnique($sourceArray)
        _ArrayDisplay($unique)
    EndIf
EndFunc
_openSourceData()