
#include <Constants.au3>

If $CmdLine[0] = 0 Then ; Main program
	StartCompilation("Program1")
	StartCompilation("Program2")
	StartCompilation("Program3")
	StartCompilation("Program4")
	StartCompilation("Program5")
Else
	Compile($CmdLine[1])
EndIf

Exit

Func StartCompilation($a)
	Run('"C:\Program Files (x86)\AutoIt3\AutoIt3.exe" ' & @ScriptName & ' ' & $a, @ScriptDir, @SW_HIDE)
EndFunc   ;==>StartCompilation

Func Compile($a)
	Local $iPID = Run('"C:\Program Files (x86)\AutoIt3\SciTE\AutoIt3Wrapper\AutoIt3Wrapper.exe" /in ' & $a & '.au3 /out ' & $a & '.exe /nopack /NoStatus', @ScriptDir, @SW_HIDE, $STDOUT_CHILD)
	Local $sOutput = ""
	While 1
		$sOutput = StdoutRead($iPID)
		If @error Then ExitLoop
		If ($sOutput <> "" And (StringInStr($sOutput, "error:") Or StringInStr($sOutput, "warning:"))) Then
			MsgBox(16, "ERROR - Compilation ABORTED", "When compiling the file " & $a & ".au3, AutoIt Compiler returned (stdout):" & @CRLF & @CRLF & $sOutput)
			Exit
		EndIf
	WEnd
EndFunc   ;==>Compile
