Opt("MustDeclareVars", 1)

Global $sResults

$sResults &= UTFx_Test(True) ;## UTF-8 - Funky
$sResults &= UTFx_Test(True, True) ;## UTF-8 - Worse
$sResults &= UTFx_Test(False) ;## UTF-16 - Works as expected

MsgBox(0, "Results", $sResults)

Func UTF8_Test($bUseUTF8, $bPartial = False)
	Local Const $iCharsToRead = 7
	Local $hFile, $iStartPos, $iEndPos, $iStrLen, $iBinLen, $sChars
	Local $sToWrite = ($bPartial ? "123456" & ChrW(185) & "789" : ChrW(185) & "23456789") ;## ChrW(185) = Superscript One

	$hFile = FileOpen(@TempDir & '\utf8_test.txt', ($bUseUTF8 ? 130 : 34)) ;## 130 = ($FO_UTF8 + $FO_OVERWRITE), 34 = ($FO_UTF16_LE + $FO_OVERWRITE)
	If $hFile <> -1 Then
		FileWrite($hFile, $sToWrite)
		FileClose($hFile)
	Else
		MsgBox(16, "UTF-" & ($bUseUTF8 ? "8" : "16") & " Test", "Failed to create test file")
		Exit (1)
	EndIf

	$hFile = FileOpen(@TempDir & '\utf8_test.txt', ($bUseUTF8 ? 128 : 32)) ;## 128 = $FO_UTF8, 32 = $FO_UTF16_LE
	If $hFile <> -1 Then
		$iStartPos = FileGetPos($hFile)
		$sChars = FileRead($hFile, $iCharsToRead)
		$iEndPos = FileGetPos($hFile)
		$iStrLen = StringLen($sChars)
		$iBinLen = BinaryLen(StringToBinary($sChars, ($bUseUTF8 ? 4 : 2))) ;## 4 = UTF-8, 2 = UTF-16LE
		FileClose($hFile)
	Else
		MsgBox(16, "UTF-" & ($bUseUTF8 ? "8" : "16") & " Test", "Failed to open test file")
		Exit (2)
	EndIf

	FileDelete(@TempDir & '\utf8_test.txt')
	Return StringFormat("UTF-%s Test\r\n-------\r\nString read: %s\r\nStarting offset: %i\r\nEnding offset: %i\r\n" & _
						"Characters read: %i\r\nExpected characters read: %i\r\nBytes read: %i\r\n\r\n", _
						($bUseUTF8 ? "8" : "16") & ($bPartial ? " - Odd offset" : ""), $sChars, $iStartPos, $iEndPos, $iStrLen, $iCharsToRead, $iBinLen)
EndFunc
