#include <Date.au3>

Dim $fh, $temp, $rc, $i, $stuff = "Jackdaws love my big sphinx of quartz."
Dim $morestuff = "The quick brown fox jumps over the lazy dog.", $UNCpath

; Prompt for UNC path to copy test data to - must exist and be writeable

$UNCpath = InputBox("Please supply a network folder name in UNC format to copy test files to", "Must exist and be writeable!", "\\<SERVER>\<SHARE>[<\PATH>]")
If $UNCpath == "" and @error == 1 Then Exit
If StringRight($UNCpath, 1) = "\" Then $UNCpath = StringLeft($UNCpath, Stringlen($UNCpath) - 1)

; Create folder and files for testing

If Not FileExists("C:\temp") Then
	If Not DirCreate("C:\temp") Then
		ConsoleWriteError("Fatal: Failed to create folder C:\temp" & @CRLF)
		Exit
	EndIf
EndIf

$temp = _NowCalcDate() & _NowTime(5)
$temp = StringLeft($temp, 4) & StringMid($temp, 6, 2) & StringMid($temp, 9, 4) & StringMid($temp, 14, 2) & StringRight($temp, 2) & ".$$$"
If Not DirCreate("C:\Temp\" & $temp) Then
	ConsoleWriteError("Fatal: Failed to create C:\Temp\" & $temp & @CRLF)
	Exit
EndIf

If Not FileChangeDir("C:\Temp\" & $temp) Then
	ConsoleWriteError("Fatal: Failed to change dir to C:\Temp\" & $temp & @CRLF)
	Exit
EndIf

$fh = FileOpen("TestFile_1.txt", 2)
If $fh == -1 Then
	ConsoleWriteError("Fatal: Failed to create TestFile_1.txt" & @CRLF)
	Exit
Else
	For $i = 1 to 10
		If Not FileWriteLine($fh, $stuff) Then
			ConsoleWriteError("Fatal: Failed to write data to TestFile_1.txt" & @CRLF)
			Exit
		EndIf
	Next
	FileClose($fh)
EndIf

$fh = FileOpen("Test File 2.txt", 2)
If $fh == -1 Then
	ConsoleWriteError("Fatal: Failed to create Test File 2.txt" & @CRLF)
	Exit
Else
	For $i = 1 to 10
		If Not FileWriteLine($fh, $morestuff) Then
			ConsoleWriteError("Fatal: Failed to write data to Test File 2.txt" & @CRLF)
			Exit
		EndIf
	Next
	FileClose($fh)
EndIf

$fh = FileOpen("Test File 3.txt", 2)
If $fh == -1 Then
	ConsoleWriteError("Fatal: Failed to create Test File 3.txt" & @CRLF)
	Exit
Else
	For $i = 1 to 5
		If Not FileWriteLine($fh, $stuff) Then
			ConsoleWriteError("Fatal: Failed to write data to Test File 3.txt" & @CRLF)
			Exit
		EndIf
	Next
	For $i = 1 to 5
		If Not FileWriteLine($fh, $morestuff) Then
			ConsoleWriteError("Fatal: Failed to write data to Test File 3.txt" & @CRLF)
			Exit
		EndIf
	Next
	FileClose($fh)
EndIf

; Do the test

; This should work

If Not FileCopy("C:\Temp\" & $temp & "\TestFile_1.txt", $UNCpath) Then
	ConsoleWrite("Error: Failed to copy C:\Temp\" & $temp & "\TestFile_1.txt to " & $UNCpath & @CRLF)
Else
	ConsoleWrite("Success!  Copied TestFile_1.txt to " & $UNCpath & @CRLF)
EndIf

; This probably won't work

If Not FileCopy("C:\Temp\" & $temp & "Test File 2.txt", $UNCpath) Then
	ConsoleWrite("Error: Failed to copy C:\Temp\" & $temp & "\Test File 2.txt to " & $UNCpath & @CRLF)
Else
	ConsoleWrite("Success!  Copied Test File 2.txt to " & $UNCpath & @CRLF)
EndIf

If Not FileCopy("""C:\Temp\" & $temp & "Test File 2.txt""", $UNCpath) Then
	ConsoleWrite("Error: Failed to copy ""C:\Temp\" & $temp & "\Test File 2.txt"" to " & $UNCpath & @CRLF)
Else
	ConsoleWrite("Success!  Copied Test File 2.txt to " & $UNCpath & @CRLF)
EndIf

If Not FileCopy("""C:\Temp\" & $temp & "Test File 2.txt""", """" & $UNCpath & """") Then
	ConsoleWrite("Error: Failed to copy ""C:\Temp\" & $temp & "\Test File 2.txt"" to " & """" & $UNCpath & """" & @CRLF)
Else
	ConsoleWrite("Success!  Copied Test File 2.txt to " & $UNCpath & @CRLF)
EndIf

If Not FileCopy("C:\Temp\" & $temp & "Test File 2.txt", """" & $UNCpath & """") Then
	ConsoleWrite("Error: Failed to copy C:\Temp\" & $temp & "\Test File 2.txt to " & """" & $UNCpath & """" & @CRLF)
Else
	ConsoleWrite("Success!  Copied Test File 2.txt to " & $UNCpath & @CRLF)
EndIf

; This should work

If FileChangeDir("C:\Temp\" & $temp) Then
	If Not FileCopy("Test File 3.txt", $UNCpath) Then
		ConsoleWrite("Error: Failed to copy C:\Temp\" & $temp & "\Test File 3.txt to " & $UNCpath & @CRLF)
	Else
		ConsoleWrite("Success!  Copied Test File 3.txt to " & $UNCpath & @CRLF)
	EndIf
Else
	ConsoleWrite("Error: Failed to change directory to C:\Temp\" & $temp & @CRLF)
EndIf

; Optionally, clean up

$rc = MsgBox(36, "Tidy up test folders and files?", "Would you like to remove the test files and folder that were copied to your systems?")
If $rc == 6 Then
	If FileExists($UNCpath & "\TestFile_1.txt") Then
		If Not FileDelete($UNCpath & "\TestFile_1.txt") Then
			ConsoleWrite("Warning: Failed to delete " & $UNCpath & "\testFile_1.txt" & @CRLF)
		EndIf
	EndIf
	If FileExists($UNCpath & "\Test File 2.txt") Then
		If Not FileDelete($UNCpath & "\Test File 2.txt") Then
			ConsoleWrite("Warning: Failed to delete " & $UNCpath & "\Test File 2.txt" & @CRLF)
		EndIf
	EndIf
	If FileExists($UNCpath & "\Test File 3.txt") Then
		If Not FileDelete($UNCpath & "\Test File 3.txt") Then
			ConsoleWrite("Warning: Failed to delete " & $UNCpath & "\Test File 3.txt" & @CRLF)
		EndIf
	EndIf
	If Not DirRemove("C:\temp\" & $temp, 1) Then
		ConsoleWrite("Warning: Failed to delete C:\temp\" & $temp & " and contents" & @CRLF)
	EndIf
EndIf

Exit