#include <Date.au3>
#include <array.au3>
;#include <string.au3>
;#include <File.au3>

#include <MsgBoxConstants.au3>
#include <GUIConstantsEx.au3>
#include <GuiEdit.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#include <GuiButton.au3>
#include <ScrollBarsConstants.au3>
#include <WinAPIFiles.au3>
#include <ProgressConstants.au3>
#include <FileConstants.au3>
#include <StaticConstants.au3>
#include <ButtonConstants.au3>
#include <GuiRichEdit.au3>

$Interrupt = 0
Opt("GUIOnEventMode", 1)
$Form1 = GUICreate("Automatischer File Copy", 470, 665)
$iOKB = GUICtrlCreateButton("Sart", 10, 10, 50, 20, $BS_BITMAP)
GUICtrlSetOnEvent(-1, "StartFunc")
$iStop = GUICtrlCreateButton("Stop", 70, 10, 50, 20)
GUICtrlSetOnEvent(-1, "StopFunc")
$ExitID = GUICtrlCreateButton("Exit", 130, 10, 50, 20)
GUICtrlSetOnEvent(-1, "_exit")
$iBCE = GUICtrlCreateRadio("Edit", 190, 4, 150, 20)
$iBRE = GUICtrlCreateRadio("RichEdit", 190, 22, 150, 20)
GUICtrlSetState($iBCE, $GUI_CHECKED)
GUIRegisterMsg($WM_COMMAND, "_WM_COMMAND") 
GUISetState()
GUISetOnEvent($GUI_EVENT_CLOSE, "_exit")
GUICtrlCreateLabel("GUICtrlCreateEdit:", 10, 40, 100, 15)
GUICtrlCreateLabel("GUICtrlRichEdit:", 240, 40, 100, 15)

$LogWindowE = GUICtrlCreateEdit("", 10, 60, 220, 580, $ES_AUTOVSCROLL + $WS_VSCROLL + $ES_AUTOHSCROLL + $WS_HSCROLL + $ES_READONLY)
GUICtrlSetBkColor(-1,0xFFFFFF)
GUICtrlSetFont(-1, 8.5, 400, 0, "MS Sans Serif")
GUICtrlSetLimit(-1,0x7FFFFFFF)
$LogWindowR = _GUICtrlRichEdit_Create($Form1, "", 240, 60, 220, 580, BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL, $WS_HSCROLL, $ES_AUTOHSCROLL, $ES_READONLY))

While 1 
	Sleep(10)
Wend

Func StartFunc()
	$Interrupt = 0
	For $counter = 1 To 1000
	If $Interrupt <> 0 Then Return
	Select
		Case BitAND(GUICtrlRead($iBCE), $GUI_CHECKED); Same
			_mylogE("Counter is: " & $counter & @CRLF)
		Case BitAND(GUICtrlRead($iBRE), $GUI_CHECKED); Same
			_mylogR("Counter is: " & $counter & @CRLF)
	EndSelect
	Next

EndFunc

Func StopFunc()
	Select
		Case BitAND(GUICtrlRead($iBCE), $GUI_CHECKED); Same
			_mylogE("Stopped" & @CRLF)
		Case BitAND(GUICtrlRead($iBRE), $GUI_CHECKED); Same
			_mylogR("Stopped" & @CRLF)
	EndSelect
EndFunc



Func _myLogR($logtext, $color = "0x000000")
	$iEndPoint = _GUICtrlRichEdit_GetTextLength($LogWindowR, True, True) - _GUICtrlRichEdit_GetLineCount($LogWindowR)
	If $iEndPoint < 0 Then $iEndPoint = 0
	_GUICtrlRichEdit_AppendText($LogWindowR, $logtext)
    ;_GuiCtrlRichEdit_SetSel($LogWindowR, $iEndPoint, -1)
    ;_GuiCtrlRichEdit_SetCharColor($LogwindowR, $color)
	;_GUICtrlRichEdit_Deselect($LogWindowR)
EndFunc

Func _mylogE($logtext)
	$bEnd = StringLen(GUICtrlRead($LogWindowE))
    _GUICtrlEdit_SetSel($LogWindowE, $bEnd, $bEnd)
    _GUICtrlEdit_Scroll($LogWindowE, $SB_SCROLLCARET)
    GUICtrlSetData($LogWindowE, $logtext, 1)
EndFunc

Func _exit()
	Exit
EndFunc

Func _WM_COMMAND($hWnd, $Msg, $wParam, $lParam)
	If BitAND($wParam, 0x0000FFFF) =  $iStop Then $Interrupt = 1
	Return $GUI_RUNDEFMSG
EndFunc
