; Test program for setting superscripts in a Rich Edit control
#include <GUIConstantsEx.au3>
#include <GuiRichEdit.au3>
Local $hGui, $hRichEdit, $hEdit, $hBtnDoit, $hBtnExit
Local $iPtr, $Char, $Length
$hGui = GUICreate ("Superscript bug demo", 400, 300)
$hRichEdit = _GUICtrlRichEdit_Create ($hGui, "x + x2 + x3 + x4 + x5", 25, 25, 350, 75)
_GUICtrlRichEdit_SetSel ($hRichEdit, 0, -1)
_GUICtrlRichEdit_SetFont($hRichEdit, 15, "Times New Roman")
_GUICtrlRichEdit_SetSel ($hRichEdit, 0, 0)
$Length = _GUICtrlRichEdit_GetTextLength ($hRichEdit)
$hEdit = GUICtrlCreateEdit ("", 25, 125, 350, 100, $ES_MULTILINE + $ES_READONLY)
$hBtnDoit = GUICtrlCreateButton ("Do It", 125, 250, 50, 25)
$hBtnExit = GUICtrlCreateButton ("Exit", 250, 250, 50, 25)
GUISetState(@SW_SHOW, $hGUI)

While 1
   Switch GUIGetMsg ()
	  Case $GUI_EVENT_CLOSE, $hBtnExit  ; "Exit" button: Exit from the program
		 ExitLoop
	  Case $hBtnDoit	; "Do It" button: try to set each digit to a superscript
		 For $iPtr = 0 to $Length
			$Char = _GUICtrlRichEdit_GetTextInRange ( $hRichEdit, $iPtr, $iPtr+1 )
			If @Error = 0 Then
			   If StringIsDigit ($Char) Then	; This character is a digit, so superscript it
				  _GUICtrlRichEdit_SetSel ( $hRichEdit, $iPtr, $iPtr+1)
				  _GUICtrlRichEdit_SetCharAttributes ($hRichEdit, "+sp")
				  _GUICtrlRichEdit_Deselect ($hRichEdit)
			   EndIf
			EndIf
		 Next
		 GUICtrlSetData ($hEdit, _GUICtrlRichEdit_StreamToVar ($hRichEdit))	; Send the RTF to the Edit control
   EndSwitch
WEnd
_GUICtrlRichEdit_Destroy($hRichEdit)
GUIDelete($hGUI)
Exit
