
#include <GuiRichEdit.au3>

Local $Text = "First line" & @CR & @CR & "Last line" & @CR
Local $iStart, $iEnd, $Line, $i
Local $TextLen
Local $FindTextError, $GetTextError
Local $MsgBuff = ""

Local $hGUI = GUICreate ("Find Text Test", 300, 300)
Local $hRichEdit = _GUICtrlRichEdit_Create ($hGUI, "", 10, 10, 280, 280)
GUISetState(@SW_SHOW, $hGUI)

_GUICtrlRichEdit_SetText ($hRichEdit, $Text)
$iStart = 0
$TextLen = _GUICtrlRichEdit_GetTextLength ($hRichEdit, True, True)
$MsgBuff = $TextLen & " characters in Rich Edit box"
For $i = 1 to 6
   If Not _GUICtrlRichEdit_GotoCharPos ($hRichEdit, $iStart) Then	; Does GotoCharPos complain about going beyond the end?
	  MsgBox (0, "", "False from GotoCharPos")	; This never happens
	  ExitLoop
   EndIf
   $iEnd = _GUICtrlRichEdit_FindText ($hRichEdit, @CR)	; Find the next CR
   If $iEnd = -1 Then ExitLoop		; FindText should return -1 if not found, but it doesn't
   $FindTextError = @error
   If $iEnd = $iStart Then
	  $Line = ""	; end = start just means a blank line
	  $GetTextError = 0
   Else
	  $Line = _GUICtrlRichEdit_GetTextInRange ($hRichEdit, $iStart, $iEnd)	; the line is all characters between start and end
	  $GetTextError = @error
   EndIf
   $MsgBuff &= @CRLF & $i & ": Start = " & $iStart & ", End = " & $iEnd & ": <" & $Line & ">  (@errors = " & $FindTextError & ", " & $GetTextError & ")"	; accumulate results
   $iStart = $iEnd + 1	; Next search starts one character after the last found CR
Next
MsgBox (0, "Test results", $MsgBuff)
_GUICtrlRichEdit_Destroy($hRichEdit)
GUIDelete($hGUI)
Exit