#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#AutoIt3Wrapper_Run_Stop_OnError=y
#AutoIt3Wrapper_Run_Tidy=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

; I am the server, start me first! (Start in second the TCPConnect example script).

#include <MsgBoxConstants.au3>

Global $iSocket

Example()

Func Example()
	TCPStartup()

	OnAutoItExitRegister("OnAutoItExit")

	Local $sIPAddress = "127.0.0.1"
	Local $iPort = 65432
	Local $iListenSocket = TCPListen($sIPAddress, $iPort, 100)
	Local $iError = 0

	If @error Then
		$iError = @error
		MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "SERVER:", "Could not listen, Error code: " & $iError)
		Return False
	EndIf

	Local $iSocket = 0
	Do
		$iSocket = TCPAccept($iListenSocket)

		If @error Then
			$iError = @error
			MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "SERVER:", "Could not accept the incoming connection, Error code: " & $iError)
			Return False
		EndIf

		$recv = TCPRecv($iSocket, 4)
		If $recv Then
			MsgBox(0, "SERVER:", "Receive: " & $recv & @CRLF & "After pressing ok, will send TCPS...")
			$send = TCPSend($iSocket, "TCPS")
		EndIf

	Until $iSocket <> -1 ;if different from -1 a client is connected.

EndFunc   ;==>Example

Func OnAutoItExit()
	TCPCloseSocket($iSocket)
	TCPShutdown()
EndFunc   ;==>OnAutoItExit
