#AutoIt3Wrapper_au3check_parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#include <GuiConstantsEx.au3>
#include <GuiTreeView.au3>
#include <WindowsConstants.au3>

Opt('MustDeclareVars', 1)

$Debug_TV = False ; Check ClassName being passed to functions, set to True and use a handle to another control to see it work

_Main()

Func _Main()

	Local $hItem[5], $hTreeView, $kitem[5][3]
	Local $iStyle = BitOR($TVS_EDITLABELS, $TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_DISABLEDRAGDROP, $TVS_SHOWSELALWAYS, $TVS_CHECKBOXES)
	
	GUICreate("TreeView Expand", 400, 300)

	$hTreeView = GUICtrlCreateTreeView(2, 2, 396, 268, $iStyle, $WS_EX_CLIENTEDGE)
	GUISetState()

	_GUICtrlTreeView_BeginUpdate($hTreeView)
	For $x = 0 To 4
		$hItem[$x] = GUICtrlCreateTreeViewItem(StringFormat("[%02d] New Item", $x), $hTreeView)
		For $y = 0 To 2
			$kitem[$x][$y] = GUICtrlCreateTreeViewItem(StringFormat("[%02d] New Item", $y), $hItem[$x])
			For $z = 0 To 2
				GUICtrlCreateTreeViewItem(StringFormat("[%02d] New Item", $z), $kItem[$x][$y])
			Next
		Next
	Next
	_GUICtrlTreeView_EndUpdate($hTreeView)

	MsgBox(4160, "Information", "Expand All")
	_GUICtrlTreeView_Expand($hTreeView)
	
	MsgBox(4160, "Information", "Collapse All")
	_GUICtrlTreeView_Expand($hTreeView, 0, False)
	
	MsgBox(4160, "Information", "Expand item 2-2")
	_GUICtrlTreeView_Expand($hTreeView, $kItem[2][2])

	MsgBox(4160, "Information", "Collapse item 2-2")
	_GUICtrlTreeView_Expand($hTreeView, $kItem[2][2], False)

	; Loop until user exits
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
	GUIDelete()
EndFunc   ;==>_Main