#Include <TreeViewConstants.au3>
#Include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#Include <GuiTreeView.au3>
Opt("GUIOnEventMode", 1)  ; Change to OnEvent mode 
Opt("GUICloseOnESC",1)

Global  $treeView, $item[10][10]
GUIRegisterMsg($WM_NOTIFY, "WM_Notify_Events")
GUICreate("TreeView Test",200,400)

$treeView = GUICtrlCreateTreeView(10,10,180,380,BitOr($TVS_HASBUTTONS,$TVS_HASLINES,$TVS_LINESATROOT,$TVS_DISABLEDRAGDROP,$TVS_SHOWSELALWAYS,$TVS_CHECKBOXES,$TVS_TRACKSELECT),$WS_EX_CLIENTEDGE )

For $x = 0 to 9
	$item[$x][0] = GUICtrlcreateTreeViewItem("Item" & $x ,$treeView)
	For $y = 1 to 9
		$item[$x][$y] = GUICtrlcreateTreeViewItem("Item" & $x & "-" & $y,$item[$x][0])
	Next
Next
GUISetOnEvent($GUI_EVENT_CLOSE, "GUIExit")
GUISetState()

While 1
	Sleep(100)
Wend

;==================================================================================================================
Func WM_Notify_Events($hWndGUI, $MsgID, $wParam, $lParam)
	#forceref $hWndGUI, $MsgID, $wParam
	Local $tagNMHDR, $event, $hwndFrom, $code
	$tagNMHDR = DllStructCreate("int;int;int", $lParam) ;NMHDR (hwndFrom, idFrom, code)
	If @error Then Return
	$event = DllStructGetData($tagNMHDR, 3)
	$xx = DllStructGetData($tagNMHDR, 1)
	$yy = DllStructGetData($tagNMHDR, 2)
	Select
	Case $wParam = $treeview
		Select
			Case $event = $NM_CLICK
				TreeView_Click()	
				
			EndSelect
	EndSelect
	; Proceed the default Autoit3 internal message commands.
	; You also can complete let the line out.
	; !!! But only 'Return' (without any value) will not proceed
	; the default Autoit3-message in the future !!!
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_Notify_Events
;==================================================================================================================
Func TreeView_Click()	
	$hItem = _GUICtrlTreeView_GetSelection($TreeView)
	If $hitem = "0x00000000" Then
		Msgbox(0,"First click",$hItem)
	EndIf
	$l_TCname = _GUICtrlTreeView_GetText($TreeView,$hItem)
	$l_Child = _GUICtrlTreeView_GetParentHandle(GUICtrlGetHandle($TreeView),$hItem)
	;Msgbox(0,"",$l_Child)
	If String($l_Child) = String("0x00000000") Then 
		;msgbox(0,"root","")
		_GUICtrlTreeView_SetChecked(GUICtrlGetHandle($TreeView), $hItem ,False)		;--- Change this
		;_GUICtrlTreeView_SetChecked(GUICtrlGetHandle($TreeView), $hItem ,True)			;--- Change this
	EndIf
EndFunc
;==================================================================================================================
Func GUIExit()
	Exit
EndFunc	
