#include <MsgBoxConstants.au3>
#include "WebSocketAsio.au3"

Main()

Func Main()
    Local $result
    Local $sWSURL = "ws://echo.websocket.events:80/"

    Global $hOnData = DllCallbackRegister("_WS_OnData", "int:cdecl", "wstr;ulong")

    _WS_EnableVerbose(1)
    _WS_RegisterOnDataCB($hOnData)

    $result = _WS_Connect($sWSURL)
    Sleep(2000)

	For $i = 1 To 100 Step +1
		$result = _WS_Send('{' & $i & '}')
		ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : _WS_Send(' & $i & ') = ' & $result & ' > Error code: ' & @error & @CRLF)

		Sleep(10) ; Adjusting or eliminating this appears to affect the result
	Next

	Sleep(500)
    _WS_Disconnect()

    Sleep(500)
    _Shutdown()
EndFunc

Func _Shutdown()
    DllCallbackFree($hOnData)
    DllClose($hWEBSOCKDLL)
EndFunc

Func _WS_OnData($vData, $iLength)
    ConsoleWrite('On Data (' & $iLength  & ') ' & $vData & @CRLF)
    return 1
EndFunc
