#AutoIt3Wrapper_au3check_parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#include <GDIPlus.au3>

Opt('MustDeclareVars', 1)

_MakeMyMultiPageTif(@MyDocumentsDir & "\GDIPlus_MultiPage.tif")

Func _MakeMyMultiPageTif($sOutFile)
    Local $sPath = RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt", "InstallDir") & "\Examples\GUI\Advanced\Images"
    Local $sCLSID, $tData, $tParams, $hImage1, $hImage2, $hImage3    
	
	_GDIPlus_Startup()
    
	$sCLSID = _GDIPlus_EncodersGetCLSID ("TIF")

    ; Create the Const Encoder Value Type struct
	$tData = DllStructCreate("int Data")
    
	; Put the Const Encoder Value Type into the struct
	DllStructSetData($tData, "Data", $GDIP_EVTMULTIFRAME)
	
	;Initiate the Encoder Parameters
    $tParams = _GDIPlus_ParamInit (1)
    _GDIPlus_ParamAdd ($tParams, $GDIP_EPGSAVEFLAG, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "Data"))

    ; Load 3 images that will be put into the tif file, the images can be different formats and sizes. 
	$hImage1 = _GDIPlus_ImageLoadFromFile($sPath & "\Red.bmp")
    $hImage2 = _GDIPlus_ImageLoadFromFile($sPath & "\Green.bmp")
    $hImage3 = _GDIPlus_ImageLoadFromFile($sPath & "\Blue.bmp")

    ; Save the first loaded image passing on the Encoder Parameters
	_GDIPlus_ImageSaveToFileEx($hImage1, $sOutFile, $sCLSID, DllStructGetPtr($tParams))

    ; Now we have saved the first image into the tif we can set the Encoder Value Type again to add the next frames
	DllStructSetData($tData, "Data", $GDIP_EVTFRAMEDIMENSIONPAGE)
    $tParams = _GDIPlus_ParamInit (1)
    _GDIPlus_ParamAdd ($tParams, $GDIP_EPGSAVEFLAG, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "Data"))

    ; Now we add the 2nd frame
    _GDIPlus_ImageSaveAddImage($hImage1, $hImage2, DllStructGetPtr($tParams))
	
	; Now we add the 3rd frame
    _GDIPlus_ImageSaveAddImage($hImage1, $hImage3, DllStructGetPtr($tParams))

    ; My images are now added to the tif file I want to set the Encoder Value Type again to flush and finalise
    DllStructSetData($tData, "Data", $GDIP_EVTFLUSH)
    $tParams = _GDIPlus_ParamInit (1)
    _GDIPlus_ParamAdd ($tParams, $GDIP_EPGSAVEFLAG, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "Data"))
    
	; Now the final step to flush the encoder and finalize the image
	_GDIPlus_ImageSaveAdd($hImage1, DllStructGetPtr($tParams))

	; Tidy up the 3 images we loaded and shutdown.
	_GDIPlus_ImageDispose($hImage1)
    _GDIPlus_ImageDispose($hImage2)
	_GDIPlus_ImageDispose($hImage3)
    _GDIPlus_Shutdown()
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageSaveAddImage
; Description ...: Adds a frame to a file or stream specified in a previous call to the _GDIPlus_ImageSaveToFileEx.
; Syntax.........: _GDIPlus_ImageSaveAddImage($hImage, $hImageNew, $pParams)
; Parameters ....: $hImage      - Handle to an image object
;                  $hImageNew   - Handle to the new image object to add
;                  $pParams     - Pointer to a $tagGDIPPENCODERPARAMS structure
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Smashly
; Modified.......: 
; Remarks .......:
; Related .......: _GDIPlus_ImageLoadFromFile, _GDIPlus_ImageSaveToFileEx, _GDIPlus_ImageSaveAdd, $tagGDIPPENCODERPARAMS
; Link ..........; @@MsdnLink@@ GdipSaveAddImage
; Example .......; Yes
; ===============================================================================================================================
Func _GDIPlus_ImageSaveAddImage($hImage, $hImageNew, $pParams)
	Local $aResult
	
	$aResult = DllCall($ghGDIPDll, "int", "GdipSaveAddImage", "hwnd", $hImage, "hwnd", $hImageNew, "ptr", $pParams)
	If @error Then Return SetError(@error, @extended, False)
	Return SetError($aResult[0], 0, $aResult[0] = 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageSaveAdd
; Description ...: Save selected frames from a multiple-frame image to another multiple-frame image.
; Syntax.........: _GDIPlus_ImageSaveAdd($hImage, $pParams)
; Parameters ....: $hImage      - Handle to an image object
;                  $pParams     - Pointer to a $tagGDIPPENCODERPARAMS structure
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Smashly
; Modified.......: 
; Remarks .......: 
; Related .......: _GDIPlus_ImageLoadFromFile, _GDIPlus_ImageSaveToFileEx, _GDIPlus_ImageSaveAddImage, $tagGDIPPENCODERPARAMS
; Link ..........; @@MsdnLink@@ GdipSaveAdd
; Example .......; Yes
; ===============================================================================================================================
Func _GDIPlus_ImageSaveAdd($hImage, $pParams)
	Local $aResult
	
	$aResult = DllCall($ghGDIPDll, "int", "GdipSaveAdd", "hwnd", $hImage, "ptr", $pParams)
	If @error Then Return SetError(@error, @extended, False)
	Return SetError($aResult[0], 0, $aResult[0] = 0)
EndFunc