#AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#include <GDIPlus.au3>

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageGetFrameDimensionCount
; Description ...: Gets the number of frame dimensions in an Image object.
; Syntax.........: _GDIPlus_ImageGetFrameDimensionCount($hImage)
; Parameters ....: $hImage      - Handle to an Image object
; Return values .: Success      - Returns the number of frame dimensions in an Image object.
;                  Failure      - @error <> 0 
; Author ........: Smashly
; Modified.......: 
; Remarks .......:
; Related .......: _GDIPlus_ImageGetFrameDimensionList, _GDIPlus_ImageGetFrameCount, _GDIPlus_ImageSelectActiveFrame
; Link ..........; @@MsdnLink@@ GdipImageGetFrameDimensionsCount
; Example .......; 
; ===============================================================================================================================
Func _GDIPlus_ImageGetFrameDimensionCount($hImage)
    Local $aResult
    
	$aResult = DllCall($ghGDIPDll, "int", "GdipImageGetFrameDimensionsCount", "hwnd", $hImage, "int*", 0)
	If @error Then Return SetError(@error, @extended, -1)
	Return SetError($aResult[0], 0, $aResult[2])
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageGetFrameDimensionList
; Description ...: Gets the identifiers for the frame dimensions of an Image object.
; Syntax.........: _GDIPlus_ImageGetFrameDimensionList($hImage, $pGUID, $iFDC)
; Parameters ....: $hImage      - Handle to an Image object
;                  $pGUID       - Pointer to a $tagGUID struct.
;                  $iFDC        - Frame Dimension Count as returned by _GDIPlus_ImageGetFrameDimensionCount
; Return values .: Success      - True
;                  Failure      - False 
; Author ........: Smashly
; Modified.......: 
; Remarks .......:  This function will set the data in the $tagGUID struct.
; Related .......: _GDIPlus_ImageGetFrameDimensionCount, _GDIPlus_ImageGetFrameCount, 
;                  _GDIPlus_ImageSelectActiveFrame, $tagGUID
; Link ..........; @@MsdnLink@@ GdipImageGetFrameDimensionsList
; Example .......; 
; ===============================================================================================================================
Func _GDIPlus_ImageGetFrameDimensionList($hImage, $pGUID, $iFDC)
    Local $aResult
	
	$aResult = DllCall($ghGDIPDll, "int", "GdipImageGetFrameDimensionsList", "hwnd", $hImage, "ptr", $pGUID, "int", $iFDC)
    If @error Then Return SetError(@error, @extended, False)
	Return SetError($aResult[0], 0, $aResult[0] = 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageGetFrameCount
; Description ...: Gets the number of frames in a specified dimension of an Image object.
; Syntax.........: _GDIPlus_ImageGetFrameCount($hImage, $pGUID)
; Parameters ....: $hImage      - Handle to an Image object
;                  $pGUID       - Pointer to a $tagGUID struct.
;                  $iFDC        - Frame Dimension Count as returned by _GDIPlus_ImageGetFrameDimensionCount
; Return values .: Success      - Returns the number of frames in the specified dimension of an Image object.
;                  Failure      - @error <> 0 
; Author ........: Smashly
; Modified.......: 
; Remarks .......:
; Related .......:  _GDIPlus_ImageGetFrameDimensionCount, _GDIPlus_ImageGetFrameDimensionList, 
;                   _GDIPlus_ImageSelectActiveFrame, $tagGUID
; Link ..........; @@MsdnLink@@ GdipImageGetFrameCount
; Example .......; 
; ===============================================================================================================================
Func _GDIPlus_ImageGetFrameCount($hImage, $pGUID)
	Local $aResult
	
	$aResult = DllCall($ghGDIPDll, "int", "GdipImageGetFrameCount", "hwnd", $hImage, "ptr", $pGUID, "int*", 0)	
	If @error Then Return SetError(@error, @extended, -1)
	Return SetError($aResult[0], 0, $aResult[3])
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _GDIPlus_ImageSelectActiveFrame
; Description ...: Selects the frame in an Image object specified by a dimension and an index..
; Syntax.........: _GDIPlus_ImageSelectActiveFrame($hImage, $pGUID, $iFDC)
; Parameters ....: $hImage      - Handle to an Image object
;                  $pGUID       - Pointer to a $tagGUID struct.
;                  $iIndex      - Index of the frame to set active.
; Return values .: Success      - True
;                  Failure      - False 
; Author ........: Smashly
; Modified.......: 
; Remarks .......:  
; Related .......: _GDIPlus_ImageGetFrameCount, _GDIPlus_ImageGetFrameDimensionCount, _GDIPlus_ImageGetFrameCount, $tagGUID
; Link ..........; @@MsdnLink@@ GdipImageSelectActiveFrame
; Example .......; 
; ===============================================================================================================================
Func _GDIPlus_ImageSelectActiveFrame($hImage, $pGUID, $iIndex)
	Local $aResult
	
	$aResult = DllCall($ghGDIPDll, "int", "GdipImageSelectActiveFrame", "hwnd", $hImage, "ptr", $pGUID, "int", $iIndex)
	If @error Then Return SetError(@error, @extended, False)
	Return SetError($aResult[0], 0, $aResult[0] = 0)
EndFunc