#AutoIt3Wrapper_Au3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6

#include <WinAPI.au3>

Opt('MustDeclareVars', 1)

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindResource
; Description ...: Determines the location of a resource with the specified type and name in the specified module.
; Syntax.........: _WinAPI_FindResource($hInstance, $sResName, $iResType)
; Parameters ....: $hInstance   - Handle to the module whose executable file contains the resource.
;                  $sResName    - Specifies the string of the resource name to be loaded.
;                  $iResType    - Specifies the resource type:
;                                 $RT_CURSOR = 1
;                                 $RT_BITMAP = 2
;                                 $RT_ICON = 3
;                                 $RT_MENU = 4
;                                 $RT_DIALOG = 5
;                                 $RT_STRING = 6
;                                 $RT_FONTDIR = 7
;                                 $RT_FONT = 8
;                                 $RT_ACCELERATOR = 9
;                                 $RT_RCDATA = 10
;                                 $RT_MESSAGETABLE = 11
;                                 $RT_GROUP_CURSOR = 12
;                                 $RT_GROUP_ICON = 14
;                                 $RT_VERSION = 16
;                                 $RT_DLGINCLUDE = 17
;                                 $RT_PLUGPLAY = 19
;                                 $RT_VXD = 20
;                                 $RT_ANICURSOR = 21
;                                 $RT_ANIICON = 22
;                                 $RT_HTML = 23
;                                 $RT_MANIFEST = 24
; Return values .: Success      - Handle to the specified resource's information block.
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall
;                                 @error 4 then it's the WinAPI error, @extended for _WinAPI_GetLastError().
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_LoadLibrary, _WinAPI_LoadLibraryEx
; Link ..........; @@MsdnLink@@ FindResourceA
; Example .......;
; ===============================================================================================================================
Func _WinAPI_FindResource($hInstance, $sResName, $iResType)
	Local $aResult, $sDec = "#"
	If Not StringIsAlNum($sResName) Then $sDec = ""
	
	$aResult = DllCall("kernel32.dll", "int", "FindResourceA", "hwnd", $hInstance, "str", $sDec & $sResName, "long", $iResType)
	If @error Then Return SetError(@error, 0, 0)
	If Not IsArray($aResult) Or $aResult[0] = 0 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Return SetError(0, 0, $aResult[0])
EndFunc   ;==>_WinAPI_FindResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FindResourceEx
; Description ...: Determines the location of the resource with the specified type, name, and language in the specified module.
; Syntax.........: _WinAPI_FindResourceEx($hInstance, $sResName, $iResType, $iLangID)
; Parameters ....: $hInstance   - Handle to the module whose executable file contains the resource.
;                  $sResName    - Specifies the string of the resource name to be loaded.
;                  $iResType    - Specifies the resource type.
;                                 $RT_CURSOR = 1
;                                 $RT_BITMAP = 2
;                                 $RT_ICON = 3
;                                 $RT_MENU = 4
;                                 $RT_DIALOG = 5
;                                 $RT_STRING = 6
;                                 $RT_FONTDIR = 7
;                                 $RT_FONT = 8
;                                 $RT_ACCELERATOR = 9
;                                 $RT_RCDATA = 10
;                                 $RT_MESSAGETABLE = 11
;                                 $RT_GROUP_CURSOR = 12
;                                 $RT_GROUP_ICON = 14
;                                 $RT_VERSION = 16
;                                 $RT_DLGINCLUDE = 17
;                                 $RT_PLUGPLAY = 19
;                                 $RT_VXD = 20
;                                 $RT_ANICURSOR = 21
;                                 $RT_ANIICON = 22
;                                 $RT_HTML = 23
;                                 $RT_MANIFEST = 24
;                  $iResLang    - Specifies the language of the resource.
; Return values .: Success      - Handle to the specified resource's information block..
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall
;                                 @error 4 then it's the WinAPI error, @extended for _WinAPI_GetLastError().
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_LoadLibrary, _WinAPI_LoadLibraryEx
; Link ..........; @@MsdnLink@@ FindResourceExA
; Example .......;
; ===============================================================================================================================
Func _WinAPI_FindResourceEx($hInstance, $sResName, $iResType, $iResLang)
	Local $aResult

	$aResult = DllCall("kernel32.dll", "int", "FindResourceExA", "hwnd", $hInstance, "long", $iResType, "str", $sResName, "short", $iResLang)
	If @error Then Return SetError(@error, 0, 0)
	If Not IsArray($aResult) Or $aResult[0] = 0 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Return SetError(0, 0, $aResult[0])
EndFunc   ;==>_WinAPI_FindResourceEx

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_SizeOfResource
; Description ...: Returns the size, in bytes, of the specified resource.
; Syntax.........: _WinAPI_SizeOfResource($hInstance, $hFindRes)
; Parameters ....: $hInstance   - Handle to the module whose executable file contains the resource.
;                  $hFindRes    - Handle to the resource as returned from _WinAPI_FindResource or _WinAPI_FindResourceEx function.
; Return values .: Success      - The number of bytes in the resource.
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall.
;                                 @error 4 then it's the WinAPI error, @extended for _WinAPI_GetLastError().
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_FindResource, _WinAPI_FindResourceEx
; Link ..........; @@MsdnLink@@ SizeofResource
; Example .......;
; ===============================================================================================================================
Func _WinAPI_SizeOfResource($hInstance, $hFindRes)
	Local $aResult

	$aResult = DllCall("kernel32.dll", "dword", "SizeofResource", "hwnd", $hInstance, "hwnd", $hFindRes)
	If @error Then Return SetError(@error, 0, 0)
	If Not IsArray($aResult) Or $aResult[0] = 0 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Return SetError(0, 0, $aResult[0])
EndFunc   ;==>_WinAPI_SizeOfResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LoadResource
; Description ...: Loads the specified resource into global memory.
; Syntax.........: _WinAPI_LoadResource($hInstance, $hFindRes)
; Parameters ....: $hInstance   - Handle to the module whose executable file contains the resource.
;                  $hFindRes    - Handle to the resource as returned from _WinAPI_FindResource or _WinAPI_FindResourceEx function.
; Return values .: Success      - Handle to the data associated with the resource.
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall.
;                                 @error 4 then it's the WinAPI error, @extended for _WinAPI_GetLastError().
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_FindResource, _WinAPI_FindResourceEx, _WinAPI_FreeResource
; Link ..........; @@MsdnLink@@ LoadResource
; Example .......;
; ===============================================================================================================================
Func _WinAPI_LoadResource($hInstance, $hFindRes)
	Local $aResult
	
	$aResult = DllCall("kernel32.dll", "int", "LoadResource", "hwnd", $hInstance, "hwnd", $hFindRes)
	If @error Then Return SetError(@error, 0, 0)
	If Not IsArray($aResult) Or $aResult[0] = 0 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Return SetError(0, 0, $aResult[0])
EndFunc   ;==>_WinAPI_LoadResource

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_LockResource
; Description ...: Locks the specified resource in memory.
; Syntax.........: _WinAPI_LockResource($hLoadRes)
; Parameters ....: $hLoadRes    - Handle to the resource to be locked as returned from _WinAPI_LoadResource function.
; Return values .: Success      - Handle to the data associated with the resource.
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall.
;                                 @error 4 then it's the WinAPI error, @extended for _WinAPI_GetLastError().
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_LoadResource
; Link ..........; @@MsdnLink@@ LockResource
; Example .......;
; ===============================================================================================================================
Func _WinAPI_LockResource($hLoadRes)
	Local $aResult
	
	$aResult = DllCall("kernel32.dll", "int", "LockResource", "hwnd", $hLoadRes)
	If @error Then Return SetError(@error, 0, 0)
	If Not IsArray($aResult) Or $aResult[0] = 0 Then Return SetError(4, _WinAPI_GetLastError(), 0)
	Return SetError(0, 0, $aResult[0])
EndFunc   ;==>_WinAPI_LockResource


; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_FreeResource
; Description ...: Decrements (decreases by one) the reference count of a loaded resource.
; Syntax.........: _WinAPI_FreeResource($hLoadRes)
; Parameters ....: $hLoadRes    - Handle of the resource to be freed as returned from _WinAPI_LoadResource.
; Return values .: Success      - Return 1
;                  Failure      - Return 0 and set @error
;                                 @error 1 ~ 3 then it's a failed AutoIt DLLCall
;                                 @error 4 then the resource was not freed, @extended for the return value of the call.
; Author ........: Smashly
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_LoadResource
; Link ..........; @@MsdnLink@@ FreeResource
; Example .......;
; ===============================================================================================================================
Func _WinAPI_FreeResource($hLoadRes)
	Local $aResult
	
	$aResult = DllCall("kernel32.dll", "int", "FreeResource", "hwnd", $hLoadRes)
	If @error Then Return SetError(1, @error, 0)
	If Not IsArray($aResult) Or $aResult[0] <> 0 Then SetError(4, $aResult[0], 0)
	Return SetError(0, 0, 1)
EndFunc   ;==>_WinAPI_FreeResource