; This script diplays information about the toolbar button the mouse is over using the TTM_*A and TTM_*W versions of the Win API ToolTip messages.
; To use hover the mouse over a toolbar button and wait until a tooltip appears, if there is one, then
; press 1 to dissplay info using TTM_*A version
; press 2 to dissplay info using TTM_*W version
; press 3 to exit

#include <GuiToolTip.au3>
#include <array.au3>

HotKeySet("1","ShowToolTipsInfoA")
HotKeySet("2","ShowToolTipsInfoW")
HotKeySet("3","Stop")

While 1
	
WEnd
Func Stop()
	Exit
EndFunc

Func ShowToolTipsInfoW()
Local $aArray = 0
Local $hTool = 0
Local $iCount = 0
Local $aArrayTips = 0

			$aArray = _WinAPI_EnumWindowsPopup()
			If IsArray($aArray) Then
				If $aArray[0][0] > 0 Then
					$hTool = $aArray[1][0]
					$iCount = _GUIToolTip_GetToolCount($hTool)
					For $i = 0 To $iCount - 1 Step 1
						$aArrayTips = _GUIToolTip_EnumToolsW($hTool, $i)
						_ArrayDisplay($aArrayTips,$i + 1 & " of " & $iCount)
					Next
				EndIf
			EndIf
		EndFunc

Func ShowToolTipsInfoA()
Local $aArray = 0
Local $hTool = 0
Local $iCount = 0
Local $aArrayTips = 0

			$aArray = _WinAPI_EnumWindowsPopup()
			If IsArray($aArray) Then
				If $aArray[0][0] > 0 Then
					$hTool = $aArray[1][0]
					$iCount = _GUIToolTip_GetToolCount($hTool)
					For $i = 0 To $iCount - 1 Step 1
						$aArrayTips = _GUIToolTip_EnumToolsA($hTool, $i)
						_ArrayDisplay($aArrayTips,$i + 1 & " of " & $iCount)
					Next
				EndIf
			EndIf
EndFunc

Func _GUIToolTip_EnumToolsA($hWnd, $iIndex)
	Local $iToolInfo, $pToolInfo, $tToolInfo, $pMemory, $tMemMap, $fResult

	$tToolInfo = DllStructCreate($tagTOOLINFO)
	$pToolInfo = DllStructGetPtr($tToolInfo)
	$iToolInfo = DllStructGetSize($tToolInfo)
	DllStructSetData($tToolInfo, "Size", $iToolInfo)
	If _WinAPI_InProcess($hWnd, $_TT_ghTTLastWnd) Then
			$fResult = _SendMessage($hWnd, $TTM_ENUMTOOLS, $iIndex, $pToolInfo, 0, "wparam", "ptr")
	Else
		$pMemory = _MemInit($hWnd, $iToolInfo, $tMemMap)
		_MemWrite($tMemMap, $pToolInfo, $pMemory, $iToolInfo)
			$fResult = _SendMessage($hWnd, $TTM_ENUMTOOLS, $iIndex, $pMemory, 0, "wparam", "ptr")
		_MemRead($tMemMap, $pMemory, $pToolInfo, $iToolInfo)
		_MemFree($tMemMap)
	EndIf
	Return _GUIToolTip_ToolToArrayA($hWnd, $tToolInfo, $fResult = True)
EndFunc   ;==>_GUIToolTip_EnumTools

Func _GUIToolTip_ToolToArrayA($hWnd, ByRef $tToolInfo, $iError)
	Local $aTool[10]

	$aTool[0] = _GUIToolTip_TTFToBits(DllStructGetData($tToolInfo, "Flags"))
	$aTool[1] = DllStructGetData($tToolInfo, "hWnd")
	$aTool[2] = DllStructGetData($tToolInfo, "ID")
	$aTool[3] = DllStructGetData($tToolInfo, "Left")
	$aTool[4] = DllStructGetData($tToolInfo, "Top")
	$aTool[5] = DllStructGetData($tToolInfo, "Right")
	$aTool[6] = DllStructGetData($tToolInfo, "Bottom")
	$aTool[7] = DllStructGetData($tToolInfo, "hInst")
	$aTool[8] = _GUIToolTip_GetTextA($hWnd, $aTool[1], $aTool[2])
	$aTool[9] = DllStructGetData($tToolInfo, "Param")
	Return SetError($iError, 0, $aTool)
EndFunc   ;==>_GUIToolTip_ToolToArray

Func _GUIToolTip_EnumToolsW($hWnd, $iIndex)
	Local $iToolInfo, $pToolInfo, $tToolInfo, $pMemory, $tMemMap, $fResult

	$tToolInfo = DllStructCreate($tagTOOLINFO)
	$pToolInfo = DllStructGetPtr($tToolInfo)
	$iToolInfo = DllStructGetSize($tToolInfo)
	DllStructSetData($tToolInfo, "Size", $iToolInfo)
	If _WinAPI_InProcess($hWnd, $_TT_ghTTLastWnd) Then
			$fResult = _SendMessage($hWnd, $TTM_ENUMTOOLSW, $iIndex, $pToolInfo, 0, "wparam", "ptr")
	Else
		$pMemory = _MemInit($hWnd, $iToolInfo, $tMemMap)
		_MemWrite($tMemMap, $pToolInfo, $pMemory, $iToolInfo)
			$fResult = _SendMessage($hWnd, $TTM_ENUMTOOLSW, $iIndex, $pMemory, 0, "wparam", "ptr")
		_MemRead($tMemMap, $pMemory, $pToolInfo, $iToolInfo)
		_MemFree($tMemMap)
	EndIf
	Return _GUIToolTip_ToolToArrayW($hWnd, $tToolInfo, $fResult = True)
EndFunc   ;==>_GUIToolTip_EnumTools

Func _GUIToolTip_ToolToArrayW($hWnd, ByRef $tToolInfo, $iError)
	Local $aTool[10]

	$aTool[0] = _GUIToolTip_TTFToBits(DllStructGetData($tToolInfo, "Flags"))
	$aTool[1] = DllStructGetData($tToolInfo, "hWnd")
	$aTool[2] = DllStructGetData($tToolInfo, "ID")
	$aTool[3] = DllStructGetData($tToolInfo, "Left")
	$aTool[4] = DllStructGetData($tToolInfo, "Top")
	$aTool[5] = DllStructGetData($tToolInfo, "Right")
	$aTool[6] = DllStructGetData($tToolInfo, "Bottom")
	$aTool[7] = DllStructGetData($tToolInfo, "hInst")
	$aTool[8] = _GUIToolTip_GetTextW($hWnd, $aTool[1], $aTool[2])
	$aTool[9] = DllStructGetData($tToolInfo, "Param")
	Return SetError($iError, 0, $aTool)
EndFunc   ;==>_GUIToolTip_ToolToArray

Func _GUIToolTip_GetTextA($hWnd, $hTool, $iID)
	Local $iToolInfo, $pToolInfo, $tToolInfo, $pBuffer, $tBuffer, $pMemory, $tMemMap, $pText

	$tBuffer = DllStructCreate("char Text[4096]")
	$pBuffer = DllStructGetPtr($tBuffer)
	$tToolInfo = DllStructCreate($tagTOOLINFO)
	$pToolInfo = DllStructGetPtr($tToolInfo)
	$iToolInfo = DllStructGetSize($tToolInfo)
	DllStructSetData($tToolInfo, "Size", $iToolInfo)
	DllStructSetData($tToolInfo, "hWnd", $hTool)
	DllStructSetData($tToolInfo, "ID", $iID)
	If _WinAPI_InProcess($hWnd, $_TT_ghTTLastWnd) Then
		DllStructSetData($tToolInfo, "Text", $pBuffer)
		_SendMessage($hWnd, $TTM_GETTEXT, 0, $pToolInfo, 0, "wparam", "ptr")
	Else
		$pMemory = _MemInit($hWnd, $iToolInfo + 4096, $tMemMap)
		$pText = $pMemory + $iToolInfo
		DllStructSetData($tToolInfo, "Text", $pText)
		_MemWrite($tMemMap, $pToolInfo, $pMemory, $iToolInfo)
		_SendMessage($hWnd, $TTM_GETTEXT, 0, $pMemory, 0, "wparam", "ptr")
		_MemRead($tMemMap, $pText, $pBuffer, 81)
		_MemFree($tMemMap)
	EndIf
	Return DllStructGetData($tBuffer, "Text")
EndFunc   ;==>_GUIToolTip_GetText

Func _GUIToolTip_GetTextW($hWnd, $hTool, $iID)
	Local $iToolInfo, $pToolInfo, $tToolInfo, $pBuffer, $tBuffer, $pMemory, $tMemMap, $pText

	$tBuffer = DllStructCreate("wchar Text[4096]")
	$pBuffer = DllStructGetPtr($tBuffer)
	$tToolInfo = DllStructCreate($tagTOOLINFO)
	$pToolInfo = DllStructGetPtr($tToolInfo)
	$iToolInfo = DllStructGetSize($tToolInfo)
	DllStructSetData($tToolInfo, "Size", $iToolInfo)
	DllStructSetData($tToolInfo, "hWnd", $hTool)
	DllStructSetData($tToolInfo, "ID", $iID)
	If _WinAPI_InProcess($hWnd, $_TT_ghTTLastWnd) Then
		DllStructSetData($tToolInfo, "Text", $pBuffer)
			_SendMessage($hWnd, $TTM_GETTEXTW, 0, $pToolInfo, 0, "wparam", "ptr")
	Else
		$pMemory = _MemInit($hWnd, $iToolInfo + 4096, $tMemMap)
		$pText = $pMemory + $iToolInfo
		DllStructSetData($tToolInfo, "Text", $pText)
		_MemWrite($tMemMap, $pToolInfo, $pMemory, $iToolInfo)
			_SendMessage($hWnd, $TTM_GETTEXTW, 0, $pMemory, 0, "wparam", "ptr")
		_MemRead($tMemMap, $pText, $pBuffer, 81)
		_MemFree($tMemMap)
	EndIf
	Return DllStructGetData($tBuffer, "Text")
EndFunc   ;==>_GUIToolTip_GetText
