#include <GUIConstantsEx.au3>

Opt('MustDeclareVars', 1)

AutoReduceMain()


; Func AutoReduceMain()
;This function currently runs the show; 
Func AutoReduceMain()
    Local $msg, $btn
    Local $File_Name, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory
	Local $File_Name_Box, $Exposure_Time_Box, $FrameRate_Box, $Total_Frames_Box, $Working_Directory_Box
	
	Local $File_Name1,$File_Name2,$File_Name3,$File_Name4,$File_Name5,$File_Name6,$File_Name7,$File_Name8,$File_Name9,$File_Name10
	Local $File_Name1_Box,$File_Name2_Box,$File_Name3_Box,$File_Name4_Box,$File_Name5_Box,$File_Name6_Box,$File_Name7_Box,$File_Name8_Box,$File_Name9_Box,$File_Name10_Box

   
   
    GUICreate("AutoReduce", 500, 550, @DesktopWidth / 4 , @DesktopHeight / 4 , -1, 0x00000018)
	
	;input boxes
    $File_Name_Box = GUICtrlCreateInput("F:\Alex\Unedited Files\capturew.avi", 10, 5, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 5)
    
	$File_Name1_Box = GUICtrlCreateInput("", 10, 35, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 35)
	
	$File_Name2_Box = GUICtrlCreateInput("", 10, 65, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 65)

	$File_Name3_Box = GUICtrlCreateInput("", 10, 95, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 95)

	$File_Name4_Box = GUICtrlCreateInput("", 10, 125, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 125)
	
	$File_Name5_Box = GUICtrlCreateInput("", 10, 155, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 155)
	
	$File_Name6_Box = GUICtrlCreateInput("", 10, 185, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 185)
	
	$File_Name7_Box = GUICtrlCreateInput("", 10, 215, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 215)
	
	$File_Name8_Box = GUICtrlCreateInput("", 10, 245, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 245)
	
	$File_Name9_Box = GUICtrlCreateInput("", 10, 275, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 275)
	
	$File_Name10_Box = GUICtrlCreateInput("", 10, 305, 300, 20)
    GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Drag raw file here", 355, 305)
	
	GUICtrlCreateLabel("//-----------------------------------------------------------------------------------------------------------------------------------------------//", 25, 327)
	$Working_Directory_Box = GUICtrlCreateInput("F:\Alex\output", 10, 345, 300, 20)
	GUICtrlSetState(-1, $GUI_DROPACCEPTED) ;accept drag & drop files for previous input control
	GUICtrlCreateLabel("Directory for processed files", 355, 345)
	
	$Exposure_Time_Box = GUICtrlCreateInput("2", 10, 375, 50, 20)   
	GUICtrlCreateLabel("Exposure Time", 355, 375)	
    
	$FrameRate_Box = GUICtrlCreateInput("30", 10, 405, 50, 20)
	GUICtrlCreateLabel("Framerate", 355,405 )
	
	$Total_Frames_Box = GUICtrlCreateInput("4500", 10, 435, 50, 20)
	GUICtrlCreateLabel("Total number of frames", 355, 435)
	
	$btn = GUICtrlCreateButton("Ok", 10, 465, 60, 20)
	
	;wait for OK click
	GUISetState()
    $msg = 0
    While $msg <> $GUI_EVENT_CLOSE
        $msg = GUIGetMsg()
        Select
            Case $msg = $btn
                ExitLoop
        EndSelect
    WEnd
	
	;get settings
	$File_Name = GUICtrlRead($File_Name_Box)
	$File_Name1 = GUICtrlRead($File_Name1_Box)
	$File_Name2 = GUICtrlRead($File_Name2_Box)
	$File_Name3 = GUICtrlRead($File_Name3_Box)
	$File_Name4 = GUICtrlRead($File_Name4_Box)
	$File_Name5 = GUICtrlRead($File_Name5_Box)
	$File_Name6 = GUICtrlRead($File_Name6_Box)
	$File_Name7 = GUICtrlRead($File_Name7_Box)
	$File_Name8 = GUICtrlRead($File_Name8_Box)
	$File_Name9 = GUICtrlRead($File_Name9_Box)
	$File_Name10 = GUICtrlRead($File_Name10_Box)
	$Exposure_Time = GUICtrlRead($Exposure_Time_Box)
	$FrameRate = GUICtrlRead($FrameRate_Box)
	$Total_Frames = GUICtrlRead($Total_Frames_Box)
	$Working_Directory = GUICtrlRead($Working_Directory_Box)
	
	
	Local $i
	for $i = 1 to 11 
	
	Switch Int($i)
	Case 1 
		if $File_Name <> "" Then
         ReduceRaw($File_Name, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
		EndIf
     Case 2
		 if $File_Name1 <> "" Then
         ReduceRaw($File_Name1, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
		 EndIf
     Case 3
		 if $File_Name2 <> "" Then
         ReduceRaw($File_Name2, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
		EndIf
     Case 4
		 if $File_Name3 <> "" Then
         ReduceRaw($File_Name3, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 5
		 if $File_Name4 <> "" Then
         ReduceRaw($File_Name4, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 6
		 if $File_Name5 <> "" Then
         ReduceRaw($File_Name5, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 7
		 if $File_Name6 <> "" Then
         ReduceRaw($File_Name6, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 8
		 if $File_Name7 <> "" Then
         ReduceRaw($File_Name7, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 9
		 if $File_Name8 <> "" Then
         ReduceRaw($File_Name8, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 10
		 if $File_Name9 <> "" Then
         ReduceRaw($File_Name9, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
	    Case 11
		 if $File_Name10 <> "" Then
         ReduceRaw($File_Name10, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	 EndIf
     Case Else
        ;
	EndSwitch 
	Next
	
	
	
	
EndFunc  


;func ReduceRaw()
;This function takes the input for a specific file and performs the VirtualDub and ImageJ reduction
Func ReduceRaw($File_Name, $Exposure_Time, $FrameRate, $Total_Frames, $Working_Directory)
	
	WinSetState("AutoReduce", "", @SW_MINIMIZE)

;start VirtualDub
	Run("VirtualDub.exe")
	WinWaitActive("VirtualDub")
	
	;open file to be processed	
	Send("!f")
	Send("{ENTER}")
	Send($File_Name)
	Send("{ENTER}")
	
	;apply 2:1 high quality reduction
	WinWaitActive("VirtualDub")
	Send("^f")
	WinActivate("Filters")
	WinWaitActive("Filters")
	Send("!a")
	Send("{LEFT}")
	Send("{ENTER}")
	Send("{ENTER}")
	
	;delete redundant frames
	If $Exposure_Time == "2" Then
	WinWaitActive("VirtualDub")
	Send("^r")
	WinActivate("Video Frame Rate Control")
	ControlClick("Video frame rate control", "", "Button7")
	Send("{ENTER}")
	EndIf
	
	;select first quarter
	WinWaitActive("VirtualDub 1.8")
	Send("^g")
	Send("0")
	Send("{ENTER}")
	Send("{HOME}")
	Send("^g")
	Send("2250")
	Send("{ENTER}")
	Send("{END}")
	
	
	
	;save first quarter reduced .avi
	Send("!f")
	Send("a")
	Send($Working_Directory)
	Send("\")
	Send("1")
	Send("{ENTER}")
	if WinActive("Save AVI 2.0 File") OR WinActive("Save") Then
		Send("{LEFT}")
		Send("{ENTER}")
	EndIf
	
	;select second quarter
	WinWaitActive("VirtualDub 1.8")
	Send("^g")
	Send("2250")
	Send("{ENTER}")
	Send("{HOME}")
	Send("^g")
	Send("4500")
	Send("{ENTER}")
	Send("{END}")
	
	;save second quarter reduced .avi
	Send("!f")
	Send("a")
	Send($Working_Directory)
	Send("\")
	Send("2")
	Send("{ENTER}")
	if WinActive("Save AVI 2.0 File") OR WinActive("Save") Then
		Send("{LEFT}")
		Send("{ENTER}")
	EndIf
	
	;select third quarter
	WinWaitActive("VirtualDub 1.8")
	Send("^g")
	Send("4500")
	Send("{ENTER}")
	Send("{HOME}")
	Send("^g")
	Send("6750")
	Send("{ENTER}")
	Send("{END}")
	
	;save third quarter reduced .avi
	Send("!f")
	Send("a")
	Send($Working_Directory)
	Send("\")
	Send("3")
	Send("{ENTER}")
	if WinActive("Save AVI 2.0 File") OR WinActive("Save") Then
		Send("{LEFT}")
		Send("{ENTER}")
	EndIf
	
	;select fourth quarter
	WinWaitActive("VirtualDub 1.8")
	Send("^g")
	Send("6750")
	Send("{ENTER}")
	Send("{HOME}")
	Send("^g")
	Send("9000")
	Send("{ENTER}")
	Send("{END}")
	
	;save fourth quarter reduced .avi
	Send("!f")
	Send("a")
	Send($Working_Directory)
	Send("\")
	Send("4")
	
	#CS
	Send("{ENTER}")
	if WinActive("Save AVI 2.0 File") OR WinActive("Save") Then
		Send("{LEFT}")
		Send("{ENTER}")
	EndIf
	
	;exit VirtualDub
	WinWaitActive("VirtualDub 1.8")
	Send("!f")
	Send("q")
	  
	  
	;start ImageJ
	Run("ImageJ.exe")
	WinWaitActive("ImageJ")
	
	
	;open file 1
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("1.avi")
	Send("{ENTER}")
	
	;select imageJ window
	WinWaitActive("1.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	WinSetState("ImageJ", "", @SW_SHOW)
	
	;reduce to 8-Bit
	;alt right right down right enter
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{ENTER}")
	WinWaitActive("ImageJ")
	
	;save
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Save as AVI...")
	Send("{ENTER}")
	Send("y")
	Sleep(3500)
	
	;close file
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("^w")
	WinWaitActive("ImageJ")
	Send("n")
	
	;open file 2
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("2.avi")
	Send("{ENTER}")
	
	;select imageJ window
	WinWaitActive("2.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	WinSetState("ImageJ", "", @SW_SHOW)
	
	;reduce to 8-Bit
	;alt right right down right enter
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{ENTER}")
	WinWaitActive("ImageJ")
	
	;save
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Save as AVI...")
	Send("{ENTER}")
	Send("y")
	Sleep(3500)
	
	;close file
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("^w")
	WinWaitActive("ImageJ")
	Send("n")
	
	;open file 3
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("3.avi")
	Send("{ENTER}")
	
	;select imageJ window
	WinWaitActive("3.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	WinSetState("ImageJ", "", @SW_SHOW)
	
	;reduce to 8-Bit
	;alt right right down right enter
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{ENTER}")
	WinWaitActive("ImageJ")
	
	;save
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Save as AVI...")
	Send("{ENTER}")
	Send("y")
	Sleep(3500)
	
	;close file
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("^w")
	WinWaitActive("ImageJ")
	Send("n")
	
	;open file 4
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("4.avi")
	Send("{ENTER}")
	
	;select imageJ window
	WinWaitActive("4.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	WinSetState("ImageJ", "", @SW_SHOW)
	
	;reduce to 8-Bit
	;alt right right down right enter
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{ENTER}")
	WinWaitActive("ImageJ")
	
	;save
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Save as AVI...")
	Send("{ENTER}")
	Send("y")
	Sleep(3500)
	
	;close file
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("^w")
	WinWaitActive("ImageJ")
	Send("n")
	
	;load all files together
	;open file 1
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("1.avi")
	Send("{ENTER}")
	WinWaitActive("1.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	
	;open file 2
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("2.avi")
	Send("{ENTER}")
	WinWaitActive("2.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	
	;open file 3
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("3.avi")
	Send("{ENTER}")
	WinWaitActive("3.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	
	;open file 4
	Send("^o")
	WinWaitActive("Open")
	Send($Working_Directory)
	Send("\")
	Send("4.avi")
	Send("{ENTER}")
	WinWaitActive("4.avi")
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	
	;concatenate files
	
	;start with first and second files
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Concatenator")
	Send("{ENTER}")
	
	;change focus back to imageJ
	;wait for window to activate
	WinSetState("ImageJ", "", @SW_SHOW)
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	;concatenate third file
	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Concatenator")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{TAB}")
	Send("{UP}")
	Send("{ENTER}")	
	
	;change focus back to imageJ
	;wait for window to activate
	WinSetState("ImageJ", "", @SW_SHOW)
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	;concatenate fourth file

	Send("{ALT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{RIGHT}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{UP}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Concatenator")
	Send("{DOWN}")
	Send("{TAB}")
	Send("{UP}")
	Send("{ENTER}")	
	
	;change focus back to imageJ
	;wait for window to activate
	WinWaitActive("Concatenated Stacks")
	WinSetState("ImageJ", "", @SW_SHOW)
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	;get original filename
	Dim $Path_Data[4]
	$Path_Data = _FileParsePath($File_Name)
	;$Path_Data[3] = Name
	;$Path_Data[4] = extension
	
	;save
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	Send("{ALT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{RIGHT}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{DOWN}")
	Send("{ENTER}")
	WinWaitActive("Save as AVI...")
	Send($Working_Directory)
	Send("\")
	Send($Path_Data[2])
	Send("R.avi")
	Send("{ENTER}")
	Sleep(12000)
	WinActivate("ImageJ")
	WinWaitActive("ImageJ")
	
	
	;exit ImageJ
	
	Send("{ALT}")
	Send("{UP}")
	Send("{UP}")
	Send("{ENTER}")
	Send("{ENTER}")
	#CE
	
EndFunc 

;===============================================================================
;
; Function Name:    _FileParsePath
; Description:      Takes a full path such as "C:\Path\File.Ext" and returns an array such as "C:","\Path\","File",".Ext"
; Parameter(s):
; Requirement(s):
; Return Value(s):  A 4-element Array.  See Description
; Author(s):        Mike Ratzlaff <mike@ratzlaff.org>
;
;===============================================================================
;
Func _FileParsePath($FileName)
    Dim $Return[4];Drive, Path, Name, Extension
    Dim $Len
    If StringMid($FileName, 2, 1) = ":" Then
        $Return[0] = StringLeft($FileName, 2)
        $FileName = StringRight($FileName, StringLen($FileName) - 2)
    Else
        $Return[0] = ''
    EndIf
    $Len = StringInStr($FileName, "\", 0, -1)
    $Return[1] = StringLeft($FileName, $Len)
    $FileName = StringRight($FileName, StringLen($FileName) - $Len)
    $Len = StringInStr($FileName, ".", 0, -1)
    $Return[2] = StringLeft($FileName, $Len - 1)
    $FileName = StringRight($FileName, StringLen($FileName) - $Len + 1)
    $Return[3] = $FileName
    Return $Return
EndFunc ;==>_FileParsePath

;===============================================================================