;#=#INDEX#==============================================================================================================================#
;#	Title .........: _PrimeExample.au3																									#
;#	Description....: Example script for _Prime.au3 					                													#
;#	Date ..........: 22.9.08                                                 															#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Examples ......: _IsPrime ( $s_number, $s_limit = 32000000 )																		#
;#					 _PrimeNext ( $s_number )																							#
;#					 _PrimePrevious ( $s_number )																						#
;#					 _IsEven ( $s_number )																								#
;#  				 _Cross ( $s_number, $s_mode=0 )																					#
;#					 _Factorial ( $s_number )																							#
;#					 _gcd ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#					 _lcm ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#					 __1000 ( $x, $s_separator = "", $ret = "" )																		#
;#======================================================================================================================================#

#include <_Prime.au3>

;Example 1 _IsPrime
MsgBox(0, "_IsPrime(123456789)", _IsPrime (123456789)) ;==> 0 123456789 is not prime

;Example 2 _IsPrime
Do
	$x = Number(InputBox("_IsPrime", "Please enter an Integer between 1 and 999999999999999"))
	If $x Then MsgBox(0, "_IsPrime", $x & " is prime ? ==> " & _IsPrime ($x) & "    ")
Until $x = ""


;Example 1 _PrimeNext
MsgBox(0, "_PrimeNext(123456789)", _PrimeNext (123456789)) ;==> next prime is 123456791

;Example 2 _PrimeNext
Do
	$x = Number(InputBox("_PrimeNext", "Please enter an Integer between 1 and 999999999999999"))
	If $x Then MsgBox(0, "_PrimeNext", $x & " next prime ? ==> " & _PrimeNext ($x) & "    ")
Until $x = ""


;Example 1 _PrimePrevious
MsgBox(0, "_PrimePrevious(123456789)", _PrimePrevious (123456789)) ;==> previous prime is 123456761

;Example 2 _PrimePrevious
Do
	$x = Number(InputBox("_PrimePrevious", "Please enter an Integer between 3 and 999999999999999"))
	If $x Then MsgBox(0, "_PrimePrevious", $x & " previous prime ? ==> " & _PrimePrevious ($x) & "    ")
Until $x = ""


;Example 1 _IsEven
MsgBox(0, "_IsEven(123456789)", _IsEven (123456789)) ;123456789 even ? ==> False

;Example 2 _IsEven
Do
	$x = Number(InputBox("_IsEven", "Please enter an Integer between 1 and 999999999999999"))
	If $x Then MsgBox(0, "_IsEven", $x & " is even ? ==> " & _IsEven ($x) & "    ")
Until $x = ""


;Example 1 _Cross
MsgBox(0, "_Cross(123456789) Simple", _Cross (123456789)) ;123456789 sum of digits ? 45

;Example 2 _Cross
MsgBox(0, "_Cross(123456789) Iterated", _Cross (123456789, 1)) ;==>123456789 iterated sum of digits ? 9

;Example 3 _Cross
Do
	$x = Number(InputBox("_Cross Simple", "Please enter an Integer"))
	If $x Then MsgBox(0, "_Cross Simple", $x & " Sum of digits ==> " & _Cross ($x) & "    ")
Until $x = ""

;Example 4 _Cross
Do
	$x = Number(InputBox("_Cross Iterated", "Please enter an Integer"))
	If $x Then MsgBox(0, "_Cross Iterated", $x & " Iterated sum of digits ==> " & _Cross ($x, 1) & "    ")
Until $x = ""


;Example 1 _Factorial
MsgBox(0, "_Factorial(123456789)", "123456789! = " & _Factorial (123456789)) ;123456789! = 362880

;Example 2 _Factorial
Do
	$x = Number(InputBox("_Factorial", "Please enter an Integer between 1 and 999999999999999"))
	If $x Then MsgBox(0, "_Factorial", $x & "! (product of digits) = " & _Factorial ($x) & "    ")
Until $x = ""


;Example 1 _gcd
$ret = _gcd (159, 78)
MsgBox(0, "_gcd(159,78) (Greatest common divisor)", "_gcd(159,78) = " & $ret[0]) ;the greatest common divisor of 159 and 78 is 3

;Example 2 _gcd
Do
	$x = Number(InputBox("_gcd (Greatest common divisor)", "Please enter the first Integer"))
	$y = Number(InputBox("_gcd (Greatest common divisor)", 'Please enter the second Integer (or more, divided by "|")'))
	If $x And $y Then
		$ret = _gcd ($x, $y)
		MsgBox(0, "_gcd", "_gcd(" & $x & "," & $y & ") = " & $ret[0] & "    ")
	EndIf
Until $x = ""


;Example 1 _lcm
$ret = _lcm (159, 78)
MsgBox(0, "_lcm(159,78) (Least Common Multiple)", "_lcm(159,78) = " & $ret[0]) ;Least Common Multiple of 159 and 78 = 4134

;Example 2 _lcm
Do
	$x = Number(InputBox("_lcm (Least Common Multiple)", "Please enter the first Integer"))
	$y = Number(InputBox("_lcm (Least Common Multiple)", 'Please enter the second Integer (or more, divided by "|")'))
	If $x And $y Then
		$ret = _lcm ($x, $y)
		MsgBox(0, "_lcm", "_lcm(" & $x & "," & $y & ") = " & $ret[0] & "    ")
	EndIf
Until $x = ""


;Example 1 __1000
MsgBox(0, "__1000(123456789)", "123456789 grouped = " & __1000 (123456789)) ;123,456,789

;Example 2 __1000
Do
	$x = Number(InputBox("__1000", "Please enter an Integer"))
	If $x Then MsgBox(0, "__1000", $x & 'grouped by "," = ' & __1000 ($x) & "    ")
Until $x = ""