;>"C:\Programme\AutoIt3\SciTE\AutoIt3Wrapper\AutoIt3Wrapper.exe" /prod /AU3Check /in "C:\_prime.au3"
;+>23:05:38 Starting AutoIt3Wrapper v.1.9.3
;>Running AU3Check (1.54.9.0)  from:C:\Programme\AutoIt3
;+>23:05:38 AU3Check ended.rc:0
;+>23:05:38 AutoIt3Wrapper Finished
;>Exit code: 0    Time: 0.417

;>"C:\Programme\AutoIt3\SciTE\tidy\tidy.exe" "C:\_prime.au3"
;Tidy AutoIt3 v2.0.17   Copyright (c) Jos van der Zande  September 9, 2007
;+> Tidy AutoIt3 finished. Original copied to:"c:\labyrinth\unicode\user\freestyle\BackUp\_prime_old2.au3"
;>Exit code: 0    Time: 0.705

;#=#INDEX#==============================================================================================================================#
;#	Title .........: _Prime.au3																											#
;#	Description....: A collection of Prime based and Prime related mathematical operations 					                			#
;#	Date ..........: 22.9.08                                                 															#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Functions......: _IsPrime ( $s_number, $s_limit = 32000000 )																		#
;#					 _PrimeNext ( $s_number )																							#
;#					 _PrimePrevious ( $s_number )																						#
;#					 _IsEven ( $s_number )																								#
;#  				 _Cross ( $s_number, $s_mode=0 )																					#
;#					 _Factorial ( $s_number )																							#
;#					 _gcd ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#					 _lcm ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#					 __1000 ( $x, $s_separator = "" )																					#
;#		Internal...: __Euclid ( $a, $b )																								#
;#					 _ggT ( $s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "" )							#
;#					 _kgV ( $s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "" )							#
;#======================================================================================================================================#

#include-once

#region;--------_IsPrime

;#=#Function#===========================================================================================================================#
;#	Name ..........: _IsPrime ( $s_number )																								#
;#	Description....: Checks if Number is Prime, Result Probability 100 %                												#
;# 	Parameters.....: $s_number = must be a positive Integer > 0           																#
;#  Return Value ..: Success:	Returns 1 if Number is Prime																			#
;#                   Failure:	Returns 0 and sets @error to 1 if Number is Composite													#
;#					 			Returns -1 and sets @error to -1 if Number is not an Integer or < 1										#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 18.9.08                                                 															#
;#	Remarks .......: Integers < 1 are excluded by Definition																			#
;# 					 _IsPrime is not a probability test, results are 100 % true. 														#
;#					 Unlike most common tests, _IsPrime is very fast, highly efficient, always true and barely consumes pc ressources	#
;#	Related .......: _PrimeNext, _PrimePrevious																							#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _IsPrime($s_number)
	If IsInt($s_number) = 0 Or $s_number < 1 Then Return SetError(-1, 0, -1)
	If $s_number = 2 Then Return 1
	If $s_number = 1 Or Mod($s_number, 2) = 0 Then Return SetError(1, 0, 0)
	Local $i = 3, $s_limit = $s_number
	While $s_limit > $i
		If Mod($s_number, $i) = 0 Then Return SetError(1, 0, 0)
		$s_limit = $s_number / $i
		$i += 2
	WEnd
	Return 1
EndFunc   ;==>_IsPrime

#endregion;--------_IsPrime
#region;--------_PrimeNext

;#=#Function#===========================================================================================================================#
;#	Name ..........: _PrimeNext ( $s_number )																							#
;#	Description....: Calculates next Prime after $s_number                																#
;# 	Parameters.....: $s_number = must be a positive Integer 	           																#
;#  Return Value ..: Success:	Returns next Prime																						#
;#                   Failure:	Returns -1 and sets @error to -1 if Number is not an Integer or negative								#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 18.9.08                                                 															#
;#	Remarks .......: Integers < 1 are excluded by Definition																			#
;#	Related .......: _IsPrime, _PrimePrevious																							#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _PrimeNext($s_number)
	If IsInt($s_number) = 0 Or $s_number < 0 Then Return SetError(-1, 0, -1)
	If $s_number < 2 Then Return 2
	Local $ret, $number = $s_number - (Mod($s_number, 2) = 0)
	While 1
		$number += 2
		$ret = _IsPrime($number)
		If $ret = 1 Then Return $number
	WEnd
EndFunc   ;==>_PrimeNext

#endregion;--------_PrimeNext
#region;--------_PrimePrevious

;#=#Function#===========================================================================================================================#
;#	Name ..........: _PrimePrevious ( $s_number )																						#
;#	Description....: Calculates previous Prime before $s_number                															#
;# 	Parameters.....: $s_number = must be a positive Integer > 2	           																#
;#  Return Value ..: Success:	Returns previous Prime																					#
;#                   Failure:	Returns -1 and sets @error to -1 if Number is not an Integer or < 3										#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 18.9.08                                                 															#
;#	Remarks .......: Integers < 1 are excluded by Definition																			#
;#	Related .......: _IsPrime, _PrimeNext																								#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _PrimePrevious($s_number)
	If IsInt($s_number) = 0 Or $s_number < 3 Then Return SetError(-1, 0, -1)
	If $s_number = 3 Then Return 2
	Local $ret, $number = $s_number + (Mod($s_number, 2) = 0)
	While 1
		$number -= 2
		$ret = _IsPrime($number)
		If $ret = 1 Then Return $number
	WEnd
EndFunc   ;==>_PrimePrevious

#endregion;--------_PrimePrevious
#region;--------_gcd

;#=#Function#===========================================================================================================================#
;#	Name ..........: _gcd ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#	Description....: Calculates the Greatest Common Divisor (gcd) of two or more passed Numbers											#
;#					 Alias : Greatest Common Denominator, Greatest Common Factor (gcf), Highest Common Factor (hcf)						#
;# 	Parameters.....: $s_number1 = 1st Integer or Array of Integers or String of Integers seperated by "|"								#																		#
;#					 $s_number2 = 2nd Integer (optional when passing an Array or a String)												#
;#					 $s_number3 = 3rd Integer (optional)																				#
;#					 $s_number4 = 4th Integer (optional)																				#
;#					 $s_number5 = 5th and last Integer (optional)																		#
;#					 If you need to pass more than 5 Integers, pass either:																#
;#						a zero based Array with Array[0] = Number of Elements (in this case, optional params will be ignored) or:		#
;#						a String with Parameters seperated by "|" (in this case, optional params will be added to String)				#
;#  Return Value ..: Success: Returns Array : Array[0] contains GCD																		#
;# 											  Array[1] contains $s_number1/GCD															#
;#											  Array[2] contains $s_number2/GCD															#
;#											  ....																						#
;#					 Failure: Returns Array = [1,$s_number1,$s_number2,...] if no GCF existent (=1)										#
;#							  Returns 0 and sets @error to 1 if one of the parameters is 0 (zero)										#
;#							  Returns 0 and sets @error to 2 if bad array or only one parameter/element passed							#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 17.9.08                                                 															#
;#  Remarks .......: All parameters will be converted to Integers, no matter what they are passed as !									#
;#					 Opt("GUIDataSeparatorChar","Chr") does not apply to this function ! (not necessary, because only numbers)			#
;#	Related .......: _lcm																												#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _gcd($s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-")
	If IsArray($s_number1) = 0 Then $s_number1 = StringSplit(StringReplace($s_number1 & "|" & $s_number2 & "|" & $s_number3 & "|" & $s_number4 & "|" & $s_number5, "|-", ""), "|")
	Local $s_array = $s_number1, $ret[UBound($s_array) ], $a = Int($s_array[1]), $i
	If $s_array[0] <> UBound($s_array) - 1 Or UBound($s_array) < 3 Then Return SetError(2, 0, $ret)
	For $i = 2 To $s_array[0]
		If $a = 0 Then Return SetError(1, 0, $ret)
		$a = __Euclid($a, $s_array[$i])
	Next
	If $a = 0 Then Return SetError(1, 0, $ret)
	For $i = 1 To $s_array[0]
		$ret[$i] = $s_array[$i] / $a
	Next
	$ret[0] = $a
	Return $ret
EndFunc   ;==>_gcd

#endregion;--------_gcd
#region;--------_ggT

;#=#Function#===========================================================================================================================#
;#	Name ..........: _ggT ( $s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "" )							#
;#	Description....: Berechnet den grten gemeindamen Teiler (ggT) von zwei oder mehr Zahlen											#
;# 					 ( German Version of _gcd )						  																	#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 17.9.08                                                 															#
;#======================================================================================================================================#

Func _ggT($s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "")
	Local $ret = _gcd($s_number1, $s_number2, $s_number3, $s_number4, $s_number5)
	SetError(@error)
	Return $ret
EndFunc   ;==>_ggT

#endregion;--------_ggT
#region;--------_lcm

;#=#Function#===========================================================================================================================#
;#	Name ..........: _lcm ( $s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-" )						#
;#	Description....: Calculates the Least Common Multiple (LCM) of two Numbers															#
;#					 Alias : Lowest Common Multiple or Smallest Common Multiple (SCM) 													#
;# 	Parameters.....: $s_number1 = 1st Integer or Array of Integers or String of Integers seperated by "|"								#																		#
;#					 $s_number2 = 2nd Integer (optional when passing an Array or a String)												#
;#					 $s_number3 = 3rd Integer (optional)																				#
;#					 $s_number4 = 4th Integer (optional)																				#
;#					 $s_number5 = 5th and last Integer (optional)																		#
;#					 If you need to pass more than 5 Integers, pass either:																#
;#						a zero based Array with Array[0] = Number of Elements (in this case, optional params will be ignored) or:		#
;#						a String with Parameters seperated by "|" (in this case, optional params will be added to String)				#
;#  Return Value ..: Success: Returns Array : Array[0] contains lcm																		#
;# 											  Array[1] contains lcm/$s_number1															#
;#											  Array[2] contains lcm/$s_number2															#
;#											  ....																						#
;#					 Failure: Returns Array and sets @error to 1 if one of the parameters is 0 (zero)									#
;#							  Returns Array and sets @error to 2 if bad array or only one parameter/element passed						#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 17.9.08                                                 															#
;#  Remarks .......: All parameters will be converted to Integers, no matter what they are passed as !									#
;#					 Opt("GUIDataSeparatorChar","Chr") does not apply to this function ! 												#
;#	Related .......: _gcd																												#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _lcm($s_number1, $s_number2 = "-", $s_number3 = "-", $s_number4 = "-", $s_number5 = "-")
	If IsArray($s_number1) = 0 Then $s_number1 = StringSplit(StringReplace($s_number1 & "|" & $s_number2 & "|" & $s_number3 & "|" & $s_number4 & "|" & $s_number5, "|-", ""), "|")
	Local $s_array = $s_number1, $ret[UBound($s_array) ], $a = Int($s_array[1]), $i
	If $s_array[0] <> UBound($s_array) - 1 Or UBound($s_array) < 3 Then Return SetError(2, 0, 0)
	For $i = 2 To $s_array[0]
		If $a = 0 Then Return SetError(1, 0, $ret)
		$a *= $s_array[$i] / __Euclid($a, $s_array[$i])
	Next
	If $a = 0 Then Return SetError(1, 0, $ret)
	For $i = 1 To $s_array[0]
		$ret[$i] = $a / $s_array[$i]
	Next
	$ret[0] = $a
	Return $ret
EndFunc   ;==>_lcm

#endregion;--------_lcm
#region;--------_kgV

;#=#Function#===========================================================================================================================#
;#	Name ..........: _kgV ( $s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "" )							#
;#	Description....: Berechnet das kleinste gemeinsame Vielfache (kgV) von zwei oder mehr Zahlen										#
;# 					 ( German Version of _lcm )						  																	#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 17.9.08                                                 															#
;#======================================================================================================================================#

Func _kgV($s_number1, $s_number2 = "", $s_number3 = "", $s_number4 = "", $s_number5 = "")
	Local $ret = _lcm($s_number1, $s_number2, $s_number3, $s_number4, $s_number5)
	SetError(@error)
	Return $ret
EndFunc   ;==>_kgV

#endregion;--------_kgV
#region;--------_IsEven

;#=#Function#===========================================================================================================================#
;#	Name ..........: _IsEven ( $s_number )																								#
;#	Description....: Checks the Parity of an Integer              																		#
;# 	Parameters.....: $s_number = Integer           																						#
;#  Return Value ..: Success:	Returns 1 if $s_number is Even 																			#
;#                   Failure:	Returns 0 if Number is Odd																				#
;#                   			Returns -1 and sets @error to -1 if Number is not an Integer											#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 20.9.08                                                 															#
;#	Related .......: _IsPrime																											#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _IsEven($s_number)
	If IsInt($s_number) = 0 Then Return SetError(-1, 0, -1)
	Return (Mod(Abs($s_number), 2) = 0)
EndFunc   ;==>_IsEven

#endregion;--------_IsEven
#region;--------_Cross

;#=#Function#===========================================================================================================================#
;#	Name ..........: _Cross ( $s_number, $s_mode=0 )																					#
;#	Description....: Performs the Crossfoot Operation (Sum of Digits) on $s_number               										#
;# 	Parameters.....: $s_number = positive Integer           																			#
;#					 $s_mode = 0 (Default): Calculates simple Crossfoot																	#
;#					 		 = 1 or any other value: Return iterated Crossfoot (loop until result is a one digit number)				#
;#  Return Value ..: Success:	Returns the Crossfoot of $s_number according to $s_mode													#
;#								In case of $s_mode <> 0 the return value will be a number with one digit								#
;#                   Failure:	Returns -1 and sets @error to -1 if Number is not an Integer											#
;#	Remarks: ......: Negative Numbers will be treated like positives																	#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 20.9.08                                                 															#
;#	Related .......: _Factorial																											#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _Cross($s_number, $s_mode = 0)
	If IsInt($s_number) = 0 Then Return SetError(-1, 0, -1)
	Local $i, $number = Abs($s_number), $ret
	Do
		For $i = 1 To StringLen($number)
			$ret += StringMid($number, $i, 1)
		Next
		If $s_mode = 0 Then Return $ret
		Dim $number = $ret, $ret = ""
	Until StringLen($number) = 1
	Return $number
EndFunc   ;==>_Cross

#endregion;--------_Cross
#region;--------_Factorial

;#=#Function#===========================================================================================================================#
;#	Name ..........: _Factorial ( $s_number )																							#
;#	Description....: Performs the Factorial Operation (Product of Digits, symbol "!") on $s_number               						#
;# 	Parameters.....: $s_number = positive Integer           																			#
;#  Return Value ..: Success:	Returns the Factorial of $s_number																		#
;#                   Failure:	Returns -1 and sets @error to -1 if Number is not an Integer or < 0										#
;#								Returns 0 if Input exceeds Autoit Limitation of 64 bit ( +9223372036854775806 | -9223372036854775807 )	#
;#	Remarks: ......: Negative Integers are excluded by Definition																		#
;#					 !0 = _Factorial(0) results 1 by Definition																			#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 20.9.08                                                 															#
;#	Related .......: _Cross																												#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func _Factorial($s_number)
	If IsInt($s_number) = 0 Or $s_number < 0 Then Return SetError(-1, 0, -1)
	If $s_number = 0 Then Return 1
	Local $i, $ret = 1
	For $i = 1 To StringLen($s_number)
		$ret *= StringMid($s_number, $i, 1)
	Next
	Return $ret
EndFunc   ;==>_Factorial

#endregion;--------_Factorial
#region;--------__Euclid

;#=#Function#===========================================================================================================================#
;#	Name ..........: __Euclid ( $a, $b )																								#
;#	Description....: Calculates the Greatest Common Factor (GCF) of two Numbers															#
;#					 Alias : Greatest Common Divisor (GCD), Highest Common Factor (HCF)													#
;# 	Parameters.....: $a = 1st Integer 																									#																		#
;#					 $b = 2nd Integer 																									#
;#  Return Value ..: Success: Returns GCF																								#
;#					 Failure: Returns 0 if one of the parameters is 0 (zero)															#
;#	Author ........: Euclid                   																							#
;#	Date ..........: ca 300 BC                                               															#
;#  Remarks .......: All parameters will be converted to Integers, no matter what they are passed as !									#
;# 					 Based on the really wonderful, incredibly fast Euclidean Algorithm (ca 300 BC) : Pseudocode:						#
;#						| function gcd(a, b)			|																				#
;#						|	if b = 0 return a			|																				#
;#						|	else return gcd(b, a mod b)	|																				#
;#======================================================================================================================================#

Func __Euclid($a, $b)
	$b = Int($b)
	If $b = 0 Then Return
	Local $t
	While $b
		$t = $b
		$b = Mod($a, $b)
		$a = $t
	WEnd
	Return $a
EndFunc   ;==>__Euclid

#endregion;--------__Euclid
#region;--------__1000 Digit Grouping

;#=#Function#===========================================================================================================================#
;#	Name ..........: __1000 ( $x, $s_separator = "," )																					#
;#	Description....: Performs a 1000 Digit Grouping (3-places) of Number or Integer                 									#
;# 	Parameters.....: $x = Input (Number)            																					#
;#					 $s_separator = Seperator Return Format																				#
;#								  = "," ==> 12,345,678 (engl., Default)																	#
;#								  = "." ==> 12.345.678 (SI)	In this case, a decimal point will be converted to a comma.					#
;#  Return Value ..: Success: Returns string representation of Number with 1000 Digit Grouping 											#
;#					 Failure: Returns $x if $s_separator different from "." or ","														#
;#	Author ........: jennico (jennicoattminusonlinedotde)                   															#
;#	Date ..........: 10.9.08                                                 															#
;#	Related .......: None																												#
;#	Example........: yes																												#
;#======================================================================================================================================#

Func __1000($x, $s_separator = ",")
	Local $ret = ""
	If StringInStr(".,", $s_separator) = 0 Then Return $x
	If StringInStr($x, ".") And StringInStr($x, "e") = 0 Then
		$ret = StringMid($x, StringInStr($x, "."))
		If $s_separator = "."  Then $ret = "," & StringMid($ret, 2)
	EndIf
	$x = Int($x)
	While StringLen(StringReplace($x, "-", "")) > 3
		$ret = $s_separator & StringRight($x, 3) & $ret
		$x = StringTrimRight($x, 3)
	WEnd
	Return $x & $ret
EndFunc   ;==>__1000

#endregion;--------_1000 Digit Grouping