Func _FileListToArray($sPath, $sFilter = "*", $iFlag = 0)
    Local $hSearch, $sFile, $asFileList[1]
    If Not FileExists($sPath) Then Return SetError(1, 1, "")
    If StringRegexp($sFilter, "[\\/:<>|]") Or (Not StringStripWS($sFilter, 8)) Then Return SetError(2, 2, "")
    If (StringMid($sPath, StringLen($sPath), 1) = "\") Then $sPath = StringTrimRight($sPath, 1); needed for Win98 for x:\  root dir
    $hSearch = FileFindFirstFile($sPath & "\" & $sFilter)
    If $hSearch = -1 Then Return SetError(4, 4, "")
    Switch $iFlag
        Case 0 ; Filas and folders
			While 1
				$sFile = FileFindNextFile($hSearch)
				If @error Then
					SetError(0)
					ExitLoop
				EndIf
				$asFileList[0] += 1
				If UBound($asFileList) <= $asFileList[0] Then ReDim $asFileList[UBound($asFileList) * 2]
				$asFileList[$asFileList[0]] = $sFile
			WEnd
        Case 1 ; Files Only
			While 1
				$sFile = FileFindNextFile($hSearch)
				If @error Then
					SetError(0)
					ExitLoop
				EndIf
				If StringInStr(FileGetAttrib($sPath & "\" & $sFile), "D") Then ContinueLoop
				$asFileList[0] += 1
				If UBound($asFileList) <= $asFileList[0] Then ReDim $asFileList[UBound($asFileList) * 2]
				$asFileList[$asFileList[0]] = $sFile
			WEnd
        Case 2 ; Folders Only
			While 1
				$sFile = FileFindNextFile($hSearch)
				If @error Then
					SetError(0)
					ExitLoop
				EndIf
				If StringInStr(FileGetAttrib($sPath & "\" & $sFile), "D") = 0 Then ContinueLoop
				$asFileList[0] += 1
				If UBound($asFileList) <= $asFileList[0] Then ReDim $asFileList[UBound($asFileList) * 2]
				$asFileList[$asFileList[0]] = $sFile
			WEnd
        Case Else
            Return SetError(3, 3, "")
    EndSwitch
    FileClose($hSearch)
    ReDim $asFileList[$asFileList[0] + 1]; Trim unused slots
    Return $asFileList
EndFunc  ;==>_FileListToArray