#include <GUIConstantsEx.au3>
#include <Array.au3>

Opt("GUIOnEventMode", 1)

Func closeApp()
	Exit
EndFunc

Func linestoarray($file)
	Local $array[1]
	Local $file1HND = FileOpen($file, 0)
	If $file1HND = -1 Then
		MsgBox(16, "File Error", "Unable to open file")
		Return False
	EndIf
	Local $line
	Local $i = 0
	While 1
		$line = FileReadLine($file1HND)
		If @error = -1 Then ExitLoop
		ReDim $array[$i+1]
		$array[$i] = $line
		$i += 1
	Wend
	FileClose($file1HND)
	Return $array
EndFunc

Func load()	
	Global $mGUI = GUICreate("Compare and Merge", 360, 100, -1, -1)
	Global $file1 = GUICtrlCreateInput("", 10, 15 + 5, 250, 20)
	Local $b1 = GUICtrlCreateButton("Load", 270, 15 + 5, 40, 20)
	Global $file2 = GUICtrlCreateInput("", 10, 15 + 45, 250, 20)
	Local $b2 = GUICtrlCreateButton("Load", 270, 15 + 45, 40, 20)
	Local $bs = GUICtrlCreateButton("OK", 320, 15 + 5, 30, 60)

	GUISetOnEvent($GUI_EVENT_CLOSE, "closeApp")
	GUICtrlSetOnEvent($b1, "b1")
	GUICtrlSetOnEvent($b2, "b2")
	GUICtrlSetOnEvent($bs, "bs")
	
	GUISetState(@SW_SHOW)
	WinActivate($mGUI, "")	
EndFunc

Func b1()
	Global $file1Loc = FileOpenDialog("Select file", @ScriptDir, "Text files (*.txt)", 3)
	GUICtrlSetData($file1, $file1Loc)
EndFunc

Func b2()
	Global $file2Loc = FileOpenDialog("Select file", @ScriptDir, "Text files (*.txt)", 3)
	GUICtrlSetData($file2, $file2Loc)
EndFunc

Func bs()
	Local $array[1]
	Local $array1 = linestoarray($file1Loc)
	Local $array2 = linestoarray($file2Loc)
	For $i=0 To UBound($array1)-1 Step 1
		ReDim $array[$i+1]
		If $array1[$i] == $array2[$i] Then
			$array[$i] = $array1[$i]
		Else
			Local $ck = choice($array1[$i], $array2[$i])
			If $ck == 1 Then $array[$i] = $array1[$i]
			If $ck == 2 Then $array[$i] = $array2[$i]
		EndIf
	Next
	_ArrayDisplay($array, "Results")
EndFunc

Func choice($ch1, $ch2)
	HotKeySet("{F8}", "sl")
	Global $checked = 0
	Global $cGUI = GUICreate("Choice", 360, 100, -1, -1)
	GUISwitch($cGUI)
	Global $Checkbox1 = GUICtrlCreateCheckbox($ch1, 10, 15+5, 300, 20)
	Global $Checkbox2 = GUICtrlCreateCheckbox($ch2, 10, 15+45, 300, 20)
	Global $cbs = GUICtrlCreateButton("OK", 320, 15 + 5, 30, 60)
	GUISetOnEvent($GUI_EVENT_CLOSE, "closeApp")
	GUICtrlSetOnEvent($cbs, "sl")
	GUISetState(@SW_SHOW)
	WinActivate($cGUI, "")
	While Not $checked
		Sleep(50)
	WEnd
	GUISwitch($mGUI)
	GUIDelete($cGUI)
	Return $checked
EndFunc

Func sl()
	If GUICtrlRead($Checkbox1) = $GUI_CHECKED Then $checked = 1
	If GUICtrlRead($Checkbox2) = $GUI_CHECKED Then $checked = 2
EndFunc

load()

While 1
	Sleep(250) ; Just idle around
WEnd