#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>

Global $ModalDialog = 0

Global $MainForm = GUICreate("Main Form", 531, 356, -1, -1, BitOR($WS_MINIMIZEBOX,$WS_SIZEBOX,$WS_THICKFRAME,$WS_SYSMENU,$WS_CAPTION,$WS_CLIPCHILDREN,$WS_POPUP,$WS_POPUPWINDOW,$WS_GROUP,$WS_BORDER,$WS_CLIPSIBLINGS), BitOR($WS_EX_ACCEPTFILES,$WS_EX_WINDOWEDGE))
GUISetIcon("Icon1.ico")
Global $btnDialog = GUICtrlCreateButton("Show Dialog", 16, 161, 89, 19, $BS_DEFPUSHBUTTON)
Global $btnBrowse = GUICtrlCreateButton("Browse For File", 120, 161, 89, 19)

GUISetState(@SW_SHOW)

While True
    $msg = GUIGetMsg()
    If $GUI_EVENT_CLOSE = $msg Then
        If 0 <> $ModalDialog And 0 <> WinGetState($ModalDialog) Then
            GUIDelete($ModalDialog)
            $ModalDialog = 0
            GUISetState(@SW_ENABLE, $MainForm)
            WinActivate($MainForm)
        Else
            Exit
        EndIf
    EndIf
    
    If $btnDialog = $msg Then CreateDialog()
    If $btnBrowse = $msg Then FileBrowse()
WEnd

Func FileBrowse()
    Local $f = FileOpenDialog("Test", "", "All Files (*.*)", 1, "", $MainForm)
EndFunc

Func CreateDialog()
    $ModalDialog = GUICreate("Dialog", 316, 231, -1, -1, BitOR($WS_SYSMENU,$WS_CAPTION,$WS_POPUP,$WS_CLIPSIBLINGS,$DS_MODALFRAME,$DS_CONTEXTHELP), -1, $MainForm)
    GUISetIcon("Icon2.ico", -1, $ModalDialog)
    
    GUISetState(@SW_SHOW, $ModalDialog)
    GUISetState(@SW_DISABLE, $MainForm)
EndFunc