#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_outfile=..\bin\BrowserCheck.exe
#AutoIt3Wrapper_res_comment=berprft den Seitenaufbau von ausgewhlten Seiten und giebt die Zeiten an eine Datenbank
#AutoIt3Wrapper_res_fileversion=0.9.1.6
#AutoIt3Wrapper_res_fileversion_autoincrement=p
#AutoIt3Wrapper_res_legalcopyright=Alexander Koch, also EDV Beratung, 35606 Solms Germany
#AutoIt3Wrapper_res_language=1031
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

$oMyError = ObjEvent("AutoIt.Error", "ComError")

#include <GUIConstantsEx.au3>
#include <IE.au3>
#include <timers.au3>
#include <File.au3>
;#include <array.au3>
#include <IEEvents.au3>


$Progname = "BrowserCheck"
Global $Settings = "Settings.ini"
$debug = true
FileInstall("Settings.ini", "Settings.ini")

Global $URLs, $GuiEnable, $Timer, $Log, $trayIcon, $Gui_EnSwitch, $Gui_DeSwitch, $GuiActivateByF8, $ErrorLog

$GUIMain = GUICreate("Event Test", 600, 500)
__IniRead()
$Label1 = GUICtrlCreateLabel("Ladevorgnge:", 8, 8, 76, 17)
$Label2 = GUICtrlCreateLabel("Durchschnitt Zeit:", 8, 32, 88, 17)
$Label3 = GUICtrlCreateLabel("Min[ms]: ", 8, 56, 46, 17)
$Label4 = GUICtrlCreateLabel("Min[Time]:", 8, 80, 52, 17)
$Label5 = GUICtrlCreateLabel("Max[ms]:", 8, 104, 46, 17)
$Label6 = GUICtrlCreateLabel("Max[Time]:", 8, 128, 55, 17)
$Label13 = GUICtrlCreateLabel("URL:", 8, 152, 55, 17)
$Label7 = GUICtrlCreateLabel("", 96, 8, 530, 17)
$Label8 = GUICtrlCreateLabel("", 96, 32, 530, 17)
$Label9 = GUICtrlCreateLabel("", 96, 56, 530, 17)
$Label10 = GUICtrlCreateLabel("", 96, 80, 530, 17)
$Label11 = GUICtrlCreateLabel("", 96, 104, 530, 17)
$Label12 = GUICtrlCreateLabel("", 96, 128, 530, 17)
$Label14 = GUICtrlCreateLabel("", 96, 152, 530, 17)
$GUIEdit = GUICtrlCreateEdit("", 10, 250, 580, 200)
$GUIProg = GUICtrlCreateProgress(10, 240, 580, 10)
$GUIExit = GUICtrlCreateButton(" Close ", 200, 450, 80, 30)
$GUIreset = GUICtrlCreateButton(" Reset ", 300, 450, 80, 30)

If $GuiEnable = "1" Or $GuiEnable = "true" Then
	GuiActivate() ;Show GUI
Else
	GuiDeActivate()
EndIf

_Timer_SetTimer($GUIMain, $Timer, "_SaveToDB")

$oShell = ObjCreate("shell.application")
While 1
	$msg = GUIGetMsg()
	If $msg = $GUI_EVENT_CLOSE Or $msg = $GUIExit Then ExitLoop
	If $msg = $GUIreset Then _reset()
	$oShellWindows = $oShell.windows
	If Not IsObj($oShellWindows) Then
		MsgBox(0, "Error", "Failed to obtain shell windows. Error: " & @error)
		Exit
	EndIf
	For $Window In $oShellWindows ; Count all existing shell windows
		_IEInit($Window)
	Next
WEnd

GUIDelete() ; Remove GUI

Exit

Func _reset($all = 1)
	_Debug_log(@ScriptLineNumber,$all,"_reset")
	For $i = 1 To UBound($Sites) - 1
		$Sites[$i][1] = 0 ; Init Time
		$Sites[$i][2] = 0 ; Work in Progress
		$Sites[$i][3] = 0 ; Min
		$Sites[$i][4] = 0 ; Min Site
		$Sites[$i][5] = 0 ; Max
		$Sites[$i][6] = 0 ; Max Site
		$Sites[$i][7] = 0 ; Zhler
		$Sites[$i][8] = 0 ; Mittelwert
	Next
	If $GuiEnable = "1" Or $GuiEnable = "true" Then
		If $all Then GUICtrlSetData($GUIEdit, "")
		GUICtrlSetData($Label7, "")
		GUICtrlSetData($Label8, "")
		GUICtrlSetData($Label9, "")
		GUICtrlSetData($Label10, "")
		GUICtrlSetData($Label11, "")
		GUICtrlSetData($Label12, "")
		GUICtrlSetData($Label14, "")
		GUICtrlSetData($GUIProg, 0)
	EndIf
EndFunc   ;==>_reset

Func _SaveToDB($hWnd, $msg, $iIDTimer, $dwTime)
	;_Debug_log(@ScriptLineNumber,"","_SaveToDB")
	#forceref $hWnd, $Msg, $iIDTimer, $dwTime
	If $Log = "1" Or $Log = "true" Then
		For $i = 1 To UBound($Sites) - 1
			If $Sites[$i][8] > 0 Then
				_FileWriteLog("Log.log", $Sites[$i][0] & "," & $Sites[$i][8] / $Sites[$i][7] & "," & _
						$Sites[$i][4] & "," & _
						$Sites[$i][3] & "," & _
						$Sites[$i][6] & "," & _
						$Sites[$i][5])
				If $GuiEnable = "1" Or $GuiEnable = "true" Then
					GUICtrlSetData($GUIEdit, $Sites[$i][0] & "," & $Sites[$i][8] / $Sites[$i][7] & "," & _
							$Sites[$i][4] & "," & _
							$Sites[$i][3] & "," & _
							$Sites[$i][6] & "," & _
							$Sites[$i][5] & @CRLF, "append")
				EndIf
			EndIf
		Next
	EndIf
	If UBound($Sites) > 1 Then
		_reset(0)
	EndIf
	__IniRead()
EndFunc   ;==>_SaveToDB

Func __IniRead()
	_Debug_log(@ScriptLineNumber,"","__IniRead")
	If Not FileExists($Settings) Then
		MsgBox(16, $Progname, "Settings.ini kann nicht gefunden werden." & @CRLF & "Programm wird beendet.")
		Exit (1)
	Else
		If IniRead($Settings, "Settings", "EnableTrayIcon", 0) = 0 Then AutoItSetOption("TrayIconHide", 1)
		$Timer = IniRead($Settings, "Settings", "Timer", 10) * 1000
		$GuiEnable = IniRead($Settings, "Settings", "Gui_Enable", 0)
		$Gui_EnSwitch = IniRead($Settings, "Settings", "Gui_EnSwitch", "")
		$Gui_DeSwitch = IniRead($Settings, "Settings", "Gui_DeSwitch", "")
		$ErrorLog = IniRead($Settings, "Settings", "ErrorLog", 0)
		$Log = IniRead($Settings, "Settings", "Log", 0)
		$URLs = IniReadSection($Settings, "Sites")
	EndIf
EndFunc   ;==>__IniRead

Func __now()
	local $now = @YEAR & "." & @MON & "." & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC
	_Debug_log(@ScriptLineNumber,$now,"__now")
	Return $now
EndFunc   ;==>__now

Func OnAutoItExit()
	For $j = 0 To UBound($ieobj) - 1
		if $ieobj[$j][1] <> "" Then
			if IsObj($ieobj[$j][1]) then 
				$ieobj[$j][1].close
			EndIf
		EndIf
	Next
EndFunc   ;==>OnAutoItExit

Func ComError()
	local $logline
	If Not $ErrorLog = 0 And Not $ErrorLog = False Then
		Local $HexNumber
		If IsObj($oMyError) Then
			$HexNumber = Hex($oMyError.number, 8)
			$logline = "AutoItCOM , ein COM erreur ist aufgetreten !" & _
					" Beschreibung : '" & @TAB & $oMyError.description & _
					"' Beschreibung Windows : '" & $oMyError.windescription & _
					"' Fehlernummer : '" & @TAB & $HexNumber & _
					"' Fehlerzeile : '" & @TAB & $oMyError.scriptline & "'" 	
			_Debug_log(@ScriptLineNumber,$logline,"ComError")
			_FileWriteLog("Error.log",$logline)
		EndIf
	EndIf
EndFunc   ;==>ComError

Func GuiActivate()
	_Debug_log(@ScriptLineNumber,"","GuiActivate")
	if $Gui_EnSwitch <> "" then HotKeySet("{" & $Gui_EnSwitch & "}")
	if $Gui_DeSwitch <> "" then HotKeySet("{" & $Gui_DeSwitch & "}", "GuiDeActivate")
	$GuiEnable = "1"
	$GuiActivateByF8 = False
	GUISetState()
EndFunc   ;==>GuiActivate

Func GuiDeActivate()
	_Debug_log(@ScriptLineNumber,"","GuiDeActivate")
	if $Gui_EnSwitch <> "" then HotKeySet("{" & $Gui_EnSwitch & "}", "GuiActivate")
	if $Gui_DeSwitch <> "" then HotKeySet("{" & $Gui_DeSwitch & "}")
	$GuiEnable = "0"
	$GuiActivateByF8 = True
	GUISetState(@SW_HIDE)
EndFunc   ;==>GuiDeActivate

func _Debug_log($Line,$msg,$FuncName="",$InclFile="")
	if $debug Then
		local $file="debug.log"
		local $logmsg = ""
		if $InclFile <> "" then $logmsg &= $InclFile & @TAB 
		if $FuncName <> "" then $logmsg &= $FuncName & @TAB 
		$logmsg &= $Line & ": " & $msg
		if @Compiled then
			_FileWriteLog($file,$logmsg)
		Else
			ConsoleWrite($logmsg  & @CRLF)
		EndIf
	EndIf
EndFunc