#include<array.au3>
$iflag = 0

; Beta Version -------------------------------
$timer = TimerInit()
For $j = 1 to 10
	$x = _FileListToArray2(@SystemDir,"*",$iflag)
Next
$timer1 = TimerDiff ($timer)

; Modified Beta Version ----------------------
$timer = TimerInit()
For $j = 1 to 10
	$x = _FileListToArray3(@SystemDir,"*",$iflag)
Next
$timer2 = TimerDiff ($timer) 

MsgBox (0, "", $timer1 & "  " & $timer2)
;_ArrayDisplay($x)

; ------------------------------------------------
Func _FileListToArray2($sPath, $sFilter = "*", $iFlag = 0)
	Local $hSearch, $sFile, $asFileList[1]
	If Not FileExists($sPath) Then Return SetError(1, 1, "")
	If (StringInStr($sFilter, "\")) Or (StringInStr($sFilter, "/")) Or (StringInStr($sFilter, ":")) Or (StringInStr($sFilter, ">")) Or (StringInStr($sFilter, "<")) Or (StringInStr($sFilter, "|")) Or (StringStripWS($sFilter, 8) = "") Then Return SetError(2, 2, "")
	If Not ($iFlag = 0 Or $iFlag = 1 Or $iFlag = 2) Then Return SetError(3, 3, "")
	If (StringMid($sPath, StringLen($sPath), 1) = "\") Then $sPath = StringTrimRight($sPath, 1) ; needed for Win98 for x:\  root dir
	$hSearch = FileFindFirstFile($sPath & "\" & $sFilter)
	If $hSearch = -1 Then Return SetError(4, 4, "")
	While 1
		$sFile = FileFindNextFile($hSearch)
		If @error Then
			SetError(0)
			ExitLoop
		EndIf
		If $iFlag = 1 And @extended Then
			ContinueLoop		; File only
		Else
			If $iFlag = 2 And @extended = 0 Then ContinueLoop	; folder only
		EndIf
		$asFileList[0] += 1
		If UBound($asFileList) <= $asFileList[0] Then ReDim $asFileList[UBound($asFileList) * 2]
		$asFileList[$asFileList[0]] = $sFile
	WEnd
	FileClose($hSearch)
	ReDim $asFileList[$asFileList[0] + 1] ; Trim unused slots
	Return $asFileList
EndFunc   ;==>_FileListToArray

Func _FileListToArray3($sPath, $sFilter = "*", $iFlag = 0)
	Local $hSearch, $sFile, $asFileList[64], $aMax = 64
	If Not FileExists($sPath) Then Return SetError(1, 1, "")
	If StringRegexp($sFilter, "[\\/:<>|]") Or (Not StringStripWS($sFilter, 8)) Then Return SetError(2, 2, "") 
	If (StringMid($sPath, StringLen($sPath), 1) = "\") Then $sPath = StringTrimRight($sPath, 1) ; needed for Win98 for x:\  root dir
	$hSearch = FileFindFirstFile($sPath & "\" & $sFilter)
	If $hSearch = -1 Then Return SetError(4, 4, "")
    Switch $iFlag
        Case 0; Files and Folders
            While 1
                $sFile = FileFindNextFile($hSearch)
                If @error Then ExitLoop
                $asFileList[0] += 1
                If $asFileList[0] = $aMax Then
					$aMax *= 2
					ReDim $asFileList[$aMax]
				EndIf
                $asFileList[$asFileList[0]] = $sFile
            WEnd
        Case 1; Files Only
            While 1
                $sFile = FileFindNextFile($hSearch)
                If @error Then ExitLoop
				If @extended Then ContinueLoop ; bypass folder
                $asFileList[0] += 1
                If $asFileList[0] = $aMax Then
					$aMax *= 2
					ReDim $asFileList[$aMax]
				EndIf
                $asFileList[$asFileList[0]] = $sFile
            WEnd
        Case 2; Folders Only
            While 1
                $sFile = FileFindNextFile($hSearch)
                If @error Then ExitLoop
				If @extended = 0 Then ContinueLoop	; bypass file
                $asFileList[0] += 1
                If $asFileList[0] = $aMax Then
					$aMax *= 2
					ReDim $asFileList[$aMax]
				EndIf
                $asFileList[$asFileList[0]] = $sFile
            WEnd
        Case Else
            Return SetError(3, 3, "")
    EndSwitch
	FileClose($hSearch)
	ReDim $asFileList[$asFileList[0] + 1] ; Trim unused slots
	Return $asFileList
EndFunc   ;==>_FileListToArray