; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_AnsiToOem
; Description ...: Translates a string into the OEM-defined character set
; Syntax.........: _WinAPI_AnsiToOem($sText)
; Parameters ....: $sText - string to translate
; Return values .: Success      - Returns translated string
;                  Failure      - 0 and sets @error
; Author ........: Zedna
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_OemToAnsi
; Link ..........; @@MsdnLink@@ CharToOem
; Example .......; Yes
; ===============================================================================================================================
Func _WinAPI_AnsiToOem($sText)
	$sText = DllCall("user32.dll","Int","CharToOem","str",$sText,"str","")
	If @error Then Return SetError(@error, 0, 0)
	Return $sText[2]
EndFunc ;==>_WinAPI_AnsiToOem

; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_OemToAnsi
; Description ...: Translates a string from the OEM-defined character set into either an ANSI or a wide-character string
; Syntax.........: _WinAPI_OemToAnsi($sText)
; Parameters ....: $sText - string to translate
; Return values .: Success      - Returns translated string
;                  Failure      - 0 and sets @error
; Author ........: Zedna
; Modified.......:
; Remarks .......:
; Related .......: _WinAPI_AnsiToOem
; Link ..........; @@MsdnLink@@ OemToChar
; Example .......; Yes
; ===============================================================================================================================
Func _WinAPI_OemToAnsi($sText)
	$sText = DllCall("user32.dll","Int","OemToChar","str",$sText,"str","")
	If @error Then Return SetError(@error, 0, 0)
	Return $sText[2]
EndFunc ;==>_WinAPI_OemToAnsi
